jQuery(document).ready(function () {
    swipper_slider()
    if (jQuery('.counter').size()){
        jQuery('.counter').countUp();
    }
    jQuery(window).scroll(function() {
        if (jQuery(this).scrollTop() > 100){
            jQuery('#masthead').addClass("sticky");
        }
        else{
            jQuery('#masthead').removeClass("sticky");

        }
    });

    AOS.init({
        // Global settings:
        disable: false, // accepts following values: 'phone', 'tablet', 'mobile', boolean, expression or function
        startEvent: 'DOMContentLoaded', // name of the event dispatched on the document, that AOS should initialize on
        initClassName: 'aos-init', // class applied after initialization
        animatedClassName: 'aos-animate', // class applied on animation
        useClassNames: false, // if true, will add content of `data-aos` as classes on scroll
        disableMutationObserver: false, // disables automatic mutations' detections (advanced)
        debounceDelay: 50, // the delay on debounce used while resizing window (advanced)
        throttleDelay: 99, // the delay on throttle used while scrolling the page (advanced)


        // Settings that can be overridden on per-element basis, by `data-aos-*` attributes:
        offset: 0, // offset (in px) from the original trigger point
        delay: 300, // values from 0 to 3000, with step 50ms
        duration: 400, // values from 0 to 3000, with step 50ms
        easing: 'ease', // default easing for AOS animations
        once: true, // whether animation should happen only once - while scrolling down
        mirror: false, // whether elements should animate out while scrolling past them
        anchorPlacement: 'top-bottom', // defines which position of the element regarding to window should trigger the animation

    });
});



function swipper_slider() {
    var menu = [];
    jQuery('.hero-slider .swiper-slide').each( function(index){
        menu.push( jQuery(this).find('.hero-slider .slide-inner').attr("data-text") );
    });
    var interleaveOffset = 0.5;
    var swiperOptions = {
        loop: true,
        speed: 1000,
        parallax: true,
        navigation: {
            nextEl: ".hero-slider .button_next_slider",
            prevEl: ".hero-slider .button_prev_slider",
        },
        pagination: {
            el: '.swiper-pagination',
            clickable: true,
        },
        autoplay: {
            delay: 4000,
            disableOnInteraction: false,
        },
        watchSlidesProgress: true,
        on: {
            progress: function() {
                var swiper = this;
                for (var i = 0; i < swiper.slides.length; i++) {
                    var slideProgress = swiper.slides[i].progress;
                    var innerOffset = swiper.width * interleaveOffset;
                    var innerTranslate = slideProgress * innerOffset;
                    swiper.slides[i].querySelector(".hero-slider .slide-inner").style.transform =
                        "translate3d(" + innerTranslate + "px, 0, 0)";
                }
            },

            touchStart: function() {
                var swiper = this;
                for (var i = 0; i < swiper.slides.length; i++) {
                    swiper.slides[i].style.transition = "";
                }
            },

            setTransition: function(speed) {
                var swiper = this;
                for (var i = 0; i < swiper.slides.length; i++) {
                    swiper.slides[i].style.transition = speed + "ms";
                    swiper.slides[i].querySelector(".hero-slider .slide-inner").style.transition =
                        speed + "ms";
                }
            }
        }
    };

    var swiper = new Swiper(".hero-slider .swiper-container", swiperOptions);

    // DATA BACKGROUND IMAGE
    var sliderBgSetting = jQuery(".hero-slider .slide-bg-image");
    sliderBgSetting.each(function(indx){
        if (jQuery(this).attr("data-background")){
            jQuery(this).css("background-image", "url(" + jQuery(this).data("background") + ")");
        }
    });


    new Swiper(".home_sec_2 .slider", {
        loop: true,
        slidesPerView: 3,
        spaceBetween: 0,
        speed: 1000,
        autoplay: {
            delay: 4000,
            disableOnInteraction: false,
        },
        navigation: {
            nextEl: ".home_sec_2 .button_next_slider",
            // prevEl: ".button_prev_slider",
        },
        breakpoints: {
            991: {
                slidesPerView: 2,
            },
            767: {
                slidesPerView: 1,
            }

        },
    });

    new Swiper(".linh_vuc_hd .slider", {
        loop: true,
        slidesPerView: 2,
        spaceBetween: 20,
        speed: 1000,
        autoplay: {
            delay: 4000,
            disableOnInteraction: false,
        },
        navigation: {
            nextEl: ".linh_vuc_hd .button_next_slider",
            prevEl: ".linh_vuc_hd .button_prev_slider",
        },
        pagination: {
            el: ".linh_vuc_hd .swiper-pagination",
            type: "fraction",
        },
        // breakpoints: {
        //     767: {
        //         slidesPerView: 2,
        //     },
        //     991: {
        //         slidesPerView: 3,
        //     }
        //
        // },
    });
    new Swiper(".home_sec_6 .slider", {
        loop: true,
        slidesPerView: 2,
        spaceBetween: 0,
        speed: 1000,
        // effect: "fade",
        slidesPerView: 4, // or 'auto'
        slidesPerColumn: 3,
        slidesPerGroup:3,
        autoplay: {
            delay: 4000,
            disableOnInteraction: false,
        },
        navigation: {
            nextEl: ".home_sec_6 .button_next_slider",
            prevEl: ".home_sec_6 .button_prev_slider",
        },
        breakpoints: {
            767: {
                slidesPerView: 3, // or 'auto'
                slidesPerColumn: 2,

            }

        },
    });

    new Swiper(".home_sec_7 .slider", {
        loop: true,
        slidesPerView: 1,
        spaceBetween: 0,
        speed: 1000,
        // effect: "fade",

        // autoplay: {
        //     delay: 4000,
        //     disableOnInteraction: false,
        // },
        navigation: {
            nextEl: ".home_sec_7 .button_next_slider",
            prevEl: ".home_sec_7 .button_prev_slider",
        },
        pagination: {
            el: '.home_sec_7 .swiper-pagination',
            clickable: true,
        },
        // breakpoints: {
        //     767: {
        //         slidesPerView: 2,
        //     },
        //     991: {
        //         slidesPerView: 3,
        //     }
        //
        // },
    });


    new Swiper(".slider_product", {
        loop: true,
        slidesPerView: 1,
        spaceBetween: 40,
        speed: 1000,
        autoplay: {
            delay: 4000,
            disableOnInteraction: false,
        },
        navigation: {
            nextEl: ".slider_product .button_next_slider",
            prevEl: ".slider_product .button_prev_slider",
        },
        breakpoints: {
            991: {
                slidesPerView: 2,
                spaceBetween: 20,

            },
            767: {
                slidesPerView: 1,
                spaceBetween: 20,

            }
        },
    });

}