(function($) {
	"use strict";
	window.isIE = /(MSIE|Trident\/|Edge\/)/i.test(navigator.userAgent);
	window.windowHeight = window.innerHeight;
	window.windowWidth = window.innerWidth;
	
	// Returns a function, that, as long as it continues to be invoked, will not
    // be triggered. The function will be called after it stops being called for
    // N milliseconds. If `immediate` is passed, trigger the function on the
    // leading edge, instead of the trailing.

    const MathUtils = {
        // map number x from range [a, b] to [c, d]
        map: (x, a, b, c, d) => (x - a) * (d - c) / (b - a) + c,
        // linear interpolation
        lerp: (a, b, n) => (1 - n) * a + n * b,
        // Random float
        getRandomFloat: (min, max) => (Math.random() * (max - min) + min).toFixed(2)
    };

    if (history.scrollRestoration) {
        history.scrollRestoration = 'manual';
        // history.scrollRestoration = 'auto';
    }

    gsap.registerPlugin(ScrollTrigger);

    function debounce(func, wait, immediate) {
        var timeout;
        return function() {
            var context = this, args = arguments;
            var later = function() {
                timeout = null;
                if (!immediate) func.apply(context, args);
            };
            var callNow = immediate && !timeout;
            clearTimeout(timeout);
            timeout = setTimeout(later, wait);
            if (callNow) func.apply(context, args);
        };
    };
    
    function wowJs() {
        if($(window).width() < 768) {
            $('.wow-mb').each(function() {
                $(this).addClass('wow');
            });
        }

        var wow = new WOW({
            boxClass:     'wow',      // animated element css class (default is wow)
            animateClass: 'animated', // animation css class (default is animated)
            mobile:       true,       // trigger animations on mobile devices (default is true)
            live:         true,       // act on asynchronously loaded content (default is true)
            callback:     function(box) {
                $(box).addClass('effect');
                $(box).removeClass('fix');
            },
            scrollContainer: null // optional scroll container selector, otherwise use window
        });
        wow.init();
    }
    
    function dataImageMobileUrl() {
        var update = function() {
            var ww = $(window).width();
            if(ww < 768) {
                $('[data-img-mb').each(function() {
                    var self = $(this),
                        url = self.attr('data-img-mb');
                    self.attr('src', url);
                });
    
                $('[data-bg-mb').each(function() {
                    var self = $(this),
                        url = self.attr('data-bg-mb');
                    self.css('background-image', 'url('+url+')');
                });
            }else {
                $('[data-img-pc]').each(function() {
                    var self = $(this),
                        url = self.attr('data-img-pc');
                    self.attr('src', url);
                });
    
                $('[data-bg-pc]').each(function() {
                    var self = $(this),
                        url = self.attr('data-bg-pc');
                    self.css('background-image', 'url('+url+')');
                });
            }
        }
        update();
        $(window).on('resize', debounce(update, 200));
    }

    function contentBulge(item, container) {
        var update = function() {
            var getWidth = Math.floor(container[0].getBoundingClientRect().x *-1);
            item.css('margin-right', getWidth+'px');
        }
        update();
        $(window).on('resize', debounce(update, 200));
    }

    function headerJs() {
        var header = $('.header');
        
        if(header.length) {
            var headeroom = new Headroom(document.querySelector("header"), {
                tolerance : 4,
                offset : 100,
                classes: {
                    pinned: "header-pin",
                    unpinned: "header-unpin"
                },
                onPin : function() {
                },
                // callback when unpinned, `this` is headroom object
                onUnpin : function() {
                },
            });
            headeroom.init();
        }

        var menuMobile = function() {
            var getHumbergerMb = $('.menuMobile .header__humberger');
            $('.header .header__humberger').on('click', function() {
                TweenMax.set('.menuMobile .header__inner', {height: $('.header .header__inner').outerHeight()});
                var width =  getHumbergerMb.width() / 2,
                    height =  getHumbergerMb.outerHeight() / 2,
                    left =  getHumbergerMb[0].getBoundingClientRect().x + width,
                    top =  getHumbergerMb[0].getBoundingClientRect().y + height,
                    wh = $(window).height();

                TweenMax.set('.menuMobile', {clipPath: `circle(0 at ${left}px ${top}px)`});
                TweenMax.set('.menuMobile .menu-list li', {yPercent: 100, autoAlpha: 0 });
                TweenMax.set('.menuMobile .header__logo', {yPercent: 100, autoAlpha: 0 });
                TweenMax.set('.menuMobile', {autoAlpha: 1 });

                var tl = new TimelineMax();
                tl.to('.menuMobile', 0.5, {clipPath: `circle(60px at ${left}px ${top}px)`, ease:Linear.easeNone});
                tl.to('.menuMobile', 0.5, {clipPath: `circle(${wh}px at ${left/1.5}px ${top}px)`, ease:Linear.easeNone});
                tl.to('.menuMobile', 0.5, {clipPath: `circle(${wh*1.5}px at ${left/1.5}px ${top}px)`, ease:Linear.easeNone});
                tl.addLabel('a');
                tl.to('.menuMobile .header__logo', 0.5, {yPercent: 0, autoAlpha: 1}, 'a-=1');
                tl.staggerTo('.menuMobile .menu-list li', 0.5, {yPercent: 0, autoAlpha: 1}, 0.1, 'a-=0.7');
            });

            $('.menuMobile .header__humberger').on('click', function() {
                var width =  getHumbergerMb.width() / 2,
                    height =  getHumbergerMb.outerHeight() / 2,
                    left =  getHumbergerMb[0].getBoundingClientRect().x + width,
                    top =  getHumbergerMb[0].getBoundingClientRect().y + height; 

                TweenMax.to('.menuMobile', 1, {clipPath: `circle(0px at ${left}px ${top}px)`, onComplete: function() {
                    TweenMax.set('.menuMobile', {autoAlpha: 0 });
                }});
            });
        }
        menuMobile();
    }

    function selectDefault() {
        var wrap = $('.select-custom');
        if(wrap.length) {
            wrap.each(function() {
                var self = $(this);
                var selectDom = self.find('select');
                selectDom.selectmenu({
                    // width: '100%',
                    appendTo: self[0],
                    open: function(){
                        self.addClass('open');
                    },
                    close: function() {
                        self.removeClass('open');
                    }
                });
            });
        }
    }

    function backToTopJs() {
        $('.footer__backtotopn').on('click', function(e) {
            e.preventDefault();
            window.scrollTo({
                top: 0,
                left: 0,
                behavior: 'smooth'
            });
        });
    }

    function btnNextSection() {
        $('.btn-next-section').on('click', function(e) {
            e.preventDefault();
            var getOffset = $($(this).attr('href')).offset().top - $('header').outerHeight();
            window.scrollTo({
                top: getOffset,
                left: 0,
                behavior: 'smooth'
            });
        });
    }

    function gridBoxJs() {
        var wrap = $('.isotopeFinterJs__inner');
        if(wrap.length) {
            wrap.each(function() {
                var $grid = $(this);
                var nav = $grid.closest('.isotopeFinterJs').find('.isotopeFinterJs__nav');
                // var sizer = $grid.find('.grid-sizer');

                var _filter = '*';

                if( nav.length ) {
                    if( nav.find('a.current').length ) {
                        _filter = nav.find('a.current').attr('data-filter');
                    }
                }
                
                $grid.isotope({
                    layoutMode: 'fitRows',
                    itemSelector: '.grid-item',
                    percentPosition: true,
                    masonry: {
                        columnWidth: '.grid-sizer'
                    },
                    filter: _filter,
                });

                if( nav.length ) {
                    nav.find('a').on('click', function(e) {
                        e.preventDefault();
                        var getFilter = $(this).attr('data-filter');

                        nav.find('a').removeClass('current');
                        $grid.isotope({ filter: getFilter });
                        $(this).addClass('current');
                    });
                }
            });
        }
    }

    function bannerSlideJs() {
        var wrap = $('.sec-banner__slide');
        var swiperDom = wrap.find('.swiper');
        if(wrap.length) {
            var swiper = new Swiper(swiperDom[0], {
                loop: true,
                slidesPerView: 1,
                spaceBetween: 0,
                effect: "fade",
                speed: 0,
                allowTouchMove: false,
                pagination: {
                    el: wrap.closest('.sec-banner').find('.swiper-pagination-custom')[0],
                    clickable: true
                },
                navigation: {
                    nextEl: wrap.closest('.sec-banner').find('.swiper-next-custom')[0],
                    prevEl: wrap.closest('.sec-banner').find('.swiper-prev-custom')[0],
                },
                autoplay: {
                    delay: 5000,
                    disableOnInteraction: false
                },
            });
            swiper.autoplay.stop();
            swiper.on('slideNextTransitionStart', function(e) {
                swiper.autoplay.stop();
                var active = swiperDom.find('.swiper-slide-active .item-img');
                TweenMax.fromTo( active[0], 0.7, {clipPath: 'inset(0 100% 0 0)'}, {clipPath: 'inset(0 0% 0 0)'} );
                TweenMax.fromTo( active.find('.bg')[0], 0.7, {scale: 1.2}, {scale: 1} );

                var fixed = swiperDom.find('.swiper-slide-active').prev();
                swiperDom.find('.swiper-slide').removeClass('z-index-1');
                if( fixed.length > 0 ) {
                    fixed.addClass('z-index-1');
                }else {
                    swiperDom.find('.swiper-slide').frist().addClass('z-index-1');
                }

            });
            swiper.on('slidePrevTransitionStart', function(e) {
                swiper.autoplay.stop();
                var active = swiperDom.find('.swiper-slide-active .item-img');
                TweenMax.fromTo( active[0], 0.7, {clipPath: 'inset(0 0 0 100%)'}, {clipPath: 'inset(0 0 0 0%)'} );
                TweenMax.fromTo( active.find('.bg')[0], 0.7, {scale: 1.2}, {scale: 1} );

                var fixed = swiperDom.find('.swiper-slide-active').next();
                swiperDom.find('.swiper-slide').removeClass('z-index-1');
                if( fixed.length > 0 ) {
                    fixed.addClass('z-index-1');
                }else {
                    swiperDom.find('.swiper-slide').frist().addClass('z-index-1');
                }
            });
            swiper.on('slideChangeTransitionEnd', function(e) {
                swiper.autoplay.start();
            });
            $(window).on('load', function() {
                setTimeout(function() {
                    swiper.autoplay.start();
                }, 3000);
            });
        }
    }
	
    function uDaiHNSlideJs() {
        var wrap = $('.sec-udhangngay__slide');
        var swiperDom = wrap.find('.swiper');
        if(wrap.length) {
            var swiper = new Swiper(swiperDom[0], {
                slidesPerView: "auto",
                spaceBetween: 16,
                pagination: {
                    el: swiperDom.find('.swiper-pagination-custom')[0],
                    clickable: true
                },
                breakpoints: {
                    768: {
                        spaceBetween: 20,
                    },
                    1024: {
                        slidesPerView: 3,
                        spaceBetween: 30,
                    },
                    1260: {
                        slidesPerView: 3,
                        spaceBetween: 35,
                    },
                    1600: {
                        slidesPerView: 3,
                        spaceBetween: 45,
                    },
                },
            });

            ScrollTrigger.create({
                trigger: wrap.closest('.sec-udhangngay')[0],
                start: "bottom bottom",
                end: "bottom top",
                // markers: true,
                once: true,
                onEnter: self => {
                    if( getOffset = wrap.closest('.sec-udhangngay').next().length && $(window).width() > 992 ) {
                        var getOffset = wrap.closest('.sec-udhangngay').next().offset().top - $('.header__wrap').outerHeight();
                        window.scrollTo({
                            top: getOffset,
                            left: 0,
                            behavior: 'smooth'
                        });
                    }
                },
            });
        }
    }

    function storeSystemSlideJs() {
        var section = $('.sec-storeSystem');
        var wrap = $('.sec-storeSystem__content');
        var swiperDom = wrap.find('.swiper');
        var _speed = 0;
        var _delay =  5000;
        if(wrap.length) {
            var swiper = new Swiper(swiperDom[0], {
                slidesPerView: 1,
                spaceBetween: 0,
                speed: _speed,
                allowTouchMove: false,
                navigation: {
                    nextEl: wrap.find('.swiper-next-custom')[0],
                    prevEl: wrap.find('.swiper-prev-custom')[0],
                },
                autoplay: {
                    delay: _delay,
                },
            });

            swiper.autoplay.stop();

            var fix = function(index, item) {
                item.find('.item-list li').removeClass('active');
                item.find('.item-list a[data-index="'+index+'"]').parent().addClass('active');
            }

            fix(swiper.activeIndex, wrap);

            swiper.on('activeIndexChange', function (e) {
                swiper.autoplay.stop()
                fix(e.activeIndex, wrap);
            });

            swiper.on('slideChangeTransitionEnd', function (e) {
                swiper.autoplay.start()
            });

            wrap.find('.item-list a').on('click', function(e) {
                e.preventDefault();
                var _self = $(this);

                if( !_self.parent().hasClass('active') ) {
                    var getIndex = _self.attr('data-index');
                    swiper.slideTo(getIndex, _speed);
                }
            });

            var bg = wrap.find('.bg-section');

            var resizeBg = function() {
                if($(window).width() < 992 ) {
                    var getTop = Math.floor(wrap.find('.item-img').height() / 2);
                    bg.css('top', getTop+'px');
                }else {
                    bg.css('top', '0px');
                }
            }
            resizeBg();
            $(window).on('resize', debounce(resizeBg, 300));

            
            if( $(window).width() > 992) {
                TweenMax.set(wrap[0], {scale: 1.1});
                TweenMax.set(wrap.find('.item-img__group')[0], {clipPath: 'inset(0 100% 0 0)'});
                TweenMax.set(wrap.find('.bg-section')[0], {clipPath: 'inset(0 0 0 100%)'});
                section.find('.wow').removeClass('wow');
                TweenMax.set('.sec-storeSystem__sharp span', {xPercent: 100});
                TweenMax.set([wrap.find('.titlebox')[0], wrap.find('.item-list li'), wrap.find('.swiper-button-custom')[0], wrap.find('.item-btn')[0] ], {yPercent: 100, autoAlpha: 0});
                
                var tl = new TimelineMax({ paused: true });
                tl.addLabel('a');
                tl.to(wrap[0], 0.5, { scale: 1 }, 'a');
                tl.to(wrap.find('.item-img__group')[0], 0.5, { clipPath: 'inset(0 0% 0 0)' }, 'a');
                tl.to(wrap.find('.bg-section')[0], 0.5, { clipPath: 'inset(0 0 0 0%)' }, 'a');
                tl.addLabel('b');
                tl.to('.sec-storeSystem__sharp span', 0.5, {xPercent: 0}, 'b-=0.2');
                tl.to(wrap.find('.titlebox')[0], 0.5, {yPercent: 0, autoAlpha: 1});
                tl.staggerTo(wrap.find('.item-list li'), 0.5, {yPercent: 0, autoAlpha: 1}, 0.1);
                if( $(window).width() < 1260 && $(window).width() > 768 ) {
                    tl.to(wrap.find('.item-btn')[0], 0.5, {yPercent: 0, autoAlpha: 1});
                }
                tl.to(wrap.find('.swiper-button-custom')[0], 0.5, {yPercent: 0, autoAlpha: 1, onComplete: function() {
                    swiper.autoplay.start();
                }});
                
                ScrollTrigger.create({
                    trigger: section[0],
                    start: "top top+=15%",
                    end: "bottom top",
                    // markers: true,
                    once: true,
    
                    onEnter: self => {
                        tl.play(); 
                    },
                });
            }else {
                TweenMax.set(wrap.find('.item-img__group')[0], {clipPath: 'inset(0 100% 0 0)'});
                TweenMax.set(wrap.find('.bg-section')[0], {clipPath: 'inset(0 0 0 100%)'});

                ScrollTrigger.create({
                    trigger: section[0],
                    start: "top bottom-=20%",
                    end: "bottom top",
                    // markers: true,
                    once: true,
                    onEnter: self => {
                        TweenMax.to(wrap.find('.item-img__group')[0], 0.5, { clipPath: 'inset(0 0% 0 0)' });
                        TweenMax.to(wrap.find('.bg-section')[0], 0.5, { clipPath: 'inset(0 0 0 0%)' });
                    },
                });
            }
        }
    }

    function netWorkSlideJs() {
        var wrap = $('.sec-netWork__slide');
        if(wrap.length) {
            var swiperDom = wrap.find('.swiper');
            var contetFixDom = wrap.find('.sec-netWork__fixContent');            
            contentBulge(contetFixDom, wrap);

            var swiper = new Swiper(swiperDom[0], {
                slidesPerView: "auto",
                spaceBetween: 0,
                pagination: {
                    el: swiperDom.find('.swiper-pagination-custom')[0],
                    clickable: true
                },
                observer: true,
                observeParents: true
            });
        }
    }
    
    function contactFormJs() {
        var wrap = $('.sec-contactForm__wrap');
        if( wrap.length ) {
            var titleDom =  wrap.find('.sec-contactForm__title');
            var btnClose =  wrap.find('.item-close');
            var contentShow =  wrap.find('.sec-contactForm__form');

            var update = function() {
                var getHeightTitle = Math.floor(titleDom.outerHeight());
                wrap.find('.sec-contactForm__inner').css('min-height', getHeightTitle+'px');
                
                if( !wrap.hasClass('show-content') ) {
                    var getWrapHeight = wrap.outerHeight();
                    wrap.closest('.footer').find('.footer__bg span').css('height', getWrapHeight+'px');
                }
            }
            update();
            titleDom.addClass('done');
            
            $(window).on('resize', debounce(update, 200));

            titleDom.on('click', function() {
                var self = $(this);
                wrap.addClass('show-content');
                titleDom.addClass('effect');
                contentShow.slideDown();
            });

            btnClose.on('click', function() {
                var self = $(this);
                wrap.removeClass('show-content');
                contentShow.slideUp();
                setTimeout(function(){
                    titleDom.removeClass('effect');
                }, 600)
            });
        }
    }

    function pageTitleScrollSection() {
        $('.sec-pageTitle .nav-line__ul a').on('click', function(e) {
            e.preventDefault();
            var self = $(this);
            var getId = self.attr('href');
            if( $(getId).length ) {
                var getOffset = $(getId).offset().top;
                window.scrollTo({
                    top: getOffset,
                    left: 0,
                    behavior: 'smooth'
                });
            }
        })
    }

    function homeAboutJs() {
        var wrap = $('.sec-homeAbout__content');
        if( wrap.length ) {
            var bgRun = wrap.find('.bg-run');
            gsap.to(bgRun[0], {
                scrollTrigger: {
                    trigger: wrap[0],
                    scrub: 0.5,
                    start: 'top bottom',
                    end: "bottom top",
                    // markers: true,
                },
                xPercent: -7,
                ease: Linear.easeNone,
            });
        }
    }

    function cursorMouseJs() {
        if ( $(window).width() > 1200 ) {
            $('body').append('<div class="cursor"><div class="cursor-inner"><span></span></div></div>');
    
            var cursorWrap = $('.cursor');
            var cursorInner = $('.cursor-inner');
    
            var mouseX = 0,
                mouseY = 0,
                lastX = 0,
                firstX = 0,
                lastY = 0,
                firstY = 0;
    
            gsap.set(cursorWrap, {
                xPercent: -50,
                yPercent: -50,
            });
    
            TweenMax.to({}, 0.01, {
                repeat: -1,
                onRepeat: function() {
                    firstX = lastX;lastX =  mouseX;firstY = lastY;lastY =  mouseY;
                    var hihiX = (firstX - lastX)*0.03;
                    var hihiY = (firstY - lastY)*0.03;
                    if( hihiX < 0 ) {
                        hihiX = hihiX*-1;
                    }
                    var skewX = hihiX;
                    if( hihiX > 1 && hihiX < 1.5 ) {
                        skewX = hihiX;
                    }else if (hihiX > 1.4 )  {
                        skewX = 1.4;
                    }else {
                        skewX = 1;
                    }
                    if( hihiY < 0 ) {
                        hihiY = hihiY*-1;
                    }
                    var skewY = hihiY;
                    if( hihiY > 1 && hihiY < 1.5 ) {
                        skewY = hihiY;
                    }else if (hihiY > 1.4 )  {
                        skewY = 1.4;
                    }else {
                        skewY = 1;
                    }
                    gsap.set(cursorWrap, {
                        x: mouseX,
                        y: mouseY,
                        scaleX: skewX,
                        scaleY: skewY,
                    });
                }
            });
    
            $(document).on("pointermove", function(e) {
                mouseX = e.clientX;
                mouseY = e.clientY;
            });
    
            $('[data-cursor-image]').on('mouseenter', function() {
                var self = $(this);
                var getImg = self.data().cursorImage;
                cursorInner.append('<img src="'+getImg+'" alt="" />');
                cursorWrap.addClass('cursor-drag');
            });
            $('[data-cursor-image]').on('mouseleave', function() {
                cursorInner.find('img').remove();
                cursorWrap.removeClass('cursor-drag');
            });

            $('[data-cursor-color]').on('mouseenter', function() {
                var self = $(this);
                var getClass = self.data().cursorColor;
                cursorWrap.addClass('color-'+getClass);
            });
            $('[data-cursor-color]').on('mouseleave', function() {
                var self = $(this);
                var getClass = self.data().cursorColor;
                cursorWrap.removeClass('color-'+getClass);
            });

            $('[data-cursor-hidden]').on('mouseenter', function() {
                cursorWrap.addClass('style-hidden');
            });
            $('[data-cursor-hidden]').on('mouseleave', function() {
                cursorWrap.removeClass('style-hidden');
            });

            var linkCursor = function(item) {
                $(item).on('mouseenter', function() {
                    cursorWrap.addClass('hover-link');
                });
                $(item).on('mouseleave', function() {
                    cursorWrap.removeClass('hover-link');
                });
            }
            linkCursor('a[href]');
            linkCursor('[data-cursor-link]');
        }
    }

    function tabboxJs() {
        var wrap = $('.tabbox');
        if( wrap.length ) {
            wrap.each(function() {
                var selfWrap = $(this);
                var navList = selfWrap.find('.nav-line__ul a');
                var panelTab = selfWrap.find('.tabbox__content .panel');

                navList.on('click', function(e) {
                    e.preventDefault();
                    var selfList = $(this);
                    var getId = selfList.attr('href');

                    if( !selfList.hasClass('current') ) {
                        $('.scrollbarPopup').scrollTop(0);
                        navList.removeClass('current');
                        selfList.addClass('current');
                        panelTab.removeClass('active');
                        $(getId).addClass('active');
                    }
                })
            });
        }

        $('.scrollbarPopup').scrollbar();
        $('[data-triggerTab-href]').on('click', function(e) {
            e.preventDefault();
            var getId = $(this).data().triggertabHref;
            $('a[href="'+getId+'"]').trigger('click');
        });
    }
    
    function popupJs() {
        $('.popup__bg, .popup__close').on('click', function() {
           $(this).closest('.popup').removeClass('show-popup');
           $('body').removeClass('body-fix-scroll');
        });
    }

    function popupTuyendungJs() {
        var dom = $('[data-btnPopupAjax]');
        if( dom.length ) {
            dom.on('click', function(e) {
                var popupBlock = $("#popup-tuyendung");
                e.preventDefault();
                var self = $(this);
                popupBlock.find(".tuyendungPopup__header .item-title").text(self.data('title'));
                popupBlock.find(".tuyendungPopup__header .item-text").text(self.data('department'));
                popupBlock.find(".tuyendungPopup__tab .tabbox__text").html(self.data('content'));
                var getId = self.attr('href');
                $(getId).addClass('show-popup');
                $('body').addClass('body-fix-scroll');
            });
        }
    }

    function effectLoadingPageJs() {
        var wrap = $('.page-loading');
        if( wrap.length ) {
            TweenMax.set('.header .header__logo', {yPercent: 50, autoAlpha: 0 });
            TweenMax.set(['.header .header__menu li', '.header .header__phone', '.header .header__humberger'], {yPercent: 100, autoAlpha: 0 });

            // check home
            if( $('.sec-banner').length ) {
                TweenMax.set(['.sec-banner__content .item-subtitle', '.sec-banner__content .item-title', '.sec-banner__content .item-btn', '.sec-banner .swiper-control .group'], {y: 100, autoAlpha: 0 });
                TweenMax.set('.sec-banner__slide .swiper', { clipPath: 'inset(0 100% 0 0)' });
            }

            var tl = new TimelineMax();
            tl.to('.page-loading', 0.5, {yPercent: 100, ease: Linear.easeNone , onComplete: function() {
                wrap.remove();
            }});
            tl.addLabel('pinA');
            tl.to('.header .header__logo', 0.5, {yPercent: 0, autoAlpha: 1}, 'pinA');
            if( $(window).width() > 1260 ) {
                tl.staggerTo( $('.header .header__menu').first().find('li'), 0.5, {yPercent: 0, autoAlpha: 1}, -0.2, 'pinA');
                tl.staggerTo( $('.header .header__menu').last().find('li'), 0.5, {yPercent: 0, autoAlpha: 1}, 0.2, 'pinA');
                if( $('.header').hasClass('header--style2') ) {
                    tl.to('.header .header__phone', 0.5, {yPercent: -50, autoAlpha: 1});
                }
            }else {
                tl.to('.header .header__phone', 0.5, {yPercent: 0, autoAlpha: 1});
                tl.to('.header .header__humberger', 0.5, {yPercent: 0, autoAlpha: 1}, '-=0.3');
            }


            // check home
            if( $('.sec-banner').length ) {
                tl.to('.sec-banner__content .item-subtitle', 0.5, {y: 0, autoAlpha: 1},'pinB-=0.2');
                tl.to('.sec-banner__content .item-title', 0.5, {y: 0, autoAlpha: 1}, '-=0.4');
                tl.addLabel('pinB');
                tl.to('.sec-banner__content .item-btn', 0.5, {y: 0, autoAlpha: 1}, '-=0.4');
    
                tl.to('.sec-banner .swiper-control .group', 0.5, {y: 0, autoAlpha: 1}, 'pinB');
    
                tl.to('.sec-banner__slide .swiper', 0.5, {clipPath: 'inset(0 0% 0 0)'}, 'pinB');
                tl.fromTo('.sec-banner__slide .swiper .swiper-slide-active .bg', 0.5, {scale: 1.2}, {scale: 1, onComplete: function() {
                    // setTimeout(function() {
                    //     $('.sec-banner__wrap .swiper-next-custom').trigger('click');
                    // }, 5000);
                }}, 'pinB');
            }
        }
    }

    function footerEffect() {
        var wrap = $('.footer');
        if( wrap.length ) {
            TweenMax.set('.footer__bg',{ yPercent: 50 });
            TweenMax.set('.sec-contactForm__inner',{ yPercent: 100, autoAlpha: 0 });
            ScrollTrigger.create({
                trigger: wrap[0],
                start: "top bottom-=20%",
                end: "bottom top",
                // markers: true,
                // once: true,
                onEnter: self => {
                    TweenMax.to('.footer__bg', 1, { yPercent: 0, onComplete: function() {
                        setTimeout(function() {
                            wrap.addClass('done');
                        }, 200);
                    } });
                    TweenMax.to('.sec-contactForm__inner',1 , {yPercent: 0, autoAlpha: 1, delay: .5 });
                },
            });   
        }
    }

    function mapBoxJs() {
        var wrap = $('.sec-mapBox');
        if( wrap.length ) {
            if( wrap.prev().length ) {
                wrap.prev().addClass('z-index-3');
                wrap.addClass('fixTop');
            }
            var list = wrap.find('.sec-mapBox__nav');
            var setMap = $('#googleMap iframe');

            list.find('.item-ul__name').on('click', function() {
                var self = $(this);
                var _parent = self.parent();

                if( !_parent.hasClass('active') ) {
                    var getSrc = _parent.attr('data-src');
                    setMap.attr('src', getSrc);
                    list.find('.item-ul__text').slideUp();
                    list.find('li').removeClass('active');

                    _parent.addClass('active');
                    _parent.find('.item-ul__text').slideDown();
                }
            });

            list.find('.item-ul__item').first().find('.item-ul__name').trigger('click');
        }
    }

    // call new
    headerJs();
    dataImageMobileUrl();
    bannerSlideJs();
    uDaiHNSlideJs();
    storeSystemSlideJs();
    netWorkSlideJs();
    backToTopJs();
    pageTitleScrollSection();
    selectDefault();
    tabboxJs();
    popupJs();
    popupTuyendungJs();
    cursorMouseJs();
    btnNextSection();
    mapBoxJs();
    
    $(window).on('load', function() {
        setTimeout(function() {
            gridBoxJs();
            contactFormJs();
            homeAboutJs();
            footerEffect();
            $('body').addClass('body-load-done');
            effectLoadingPageJs();
            wowJs();
        }, 1000);// default 500ms loading
    });
})(jQuery);

// resize fix load page 
jQuery(function($) {
    var windowWidth = $(window).width();
    var windowHeight = $(window).height();
 
    $(window).resize(function() {
       if (windowWidth != $(window).width() || windowHeight != $(window).height()) {
          location.reload();
          return;
       }
    });
});