(function($) {
	"use strict";

    function offerSearchByStore() {
        $("#offerStoreSearch").on('selectmenuchange', function() {
            window.location.href = $(this).val();
        });
    }

    $("#btnViewmoreOffer").on('click', function (e) {
        e.preventDefault();
        var postid = $('#offerDetailId').val();
        var store = $('#offer-ajax-form input[name="ajax-store"]').val();
        var category = $('#offer-ajax-form input[name="ajax-category"]').val();
        var page = $('#offer-ajax-form input[name="ajax-page"]').val();
        var postnum = $('#offer-ajax-form input[name="ajax-postnum"]').val();
        $('.loading-page').show();
        $('body').css("opacity", "0.5");
        $.ajax({
            type: 'POST',
            url: theme_admin_url,
            dataType: "json", // add data type
            data: {
                action: 'get_ajax_offers',
                postid: postid,
                store: store,
                category: category,
                page: page,
                postnum: postnum
            },
            success: function( response ) {
                if (response.success === true) {
                    if (response.data) {
                        $('.postBox-list .row').append(response.data);
                        $('#offer-ajax-form input[name="ajax-page"]').val(parseInt(page) + 1);
                        if (parseInt(postnum) <= $(".postBox-list .postBox").length) {
                            $("#btnViewmoreOffer").hide();
                        }
                        $('.loading-page').hide();
                        $('body').css("opacity", "1");
                    } else {
                        $('.loading-page').hide();
                        $('body').css("opacity", "1");
                    }
                }
                $('.loading-page').hide();
                $('body').css("opacity", "1");
            }
        });
    });

    $("#btnViewmoreNews").on('click', function (e) {
        e.preventDefault();
        var postid = $('#newsDetailId').val();
        var category = $('#news-ajax-form input[name="ajax-category"]').val();
        var page = $('#news-ajax-form input[name="ajax-page"]').val();
        var postnum = $('#news-ajax-form input[name="ajax-postnum"]').val();
        $('.loading-page').show();
        $('body').css("opacity", "0.5");
        $.ajax({
            type: 'POST',
            url: theme_admin_url,
            dataType: "json", // add data type
            data: {
                action: 'get_ajax_news',
                postid: postid,
                category: category,
                page: page,
                postnum: postnum
            },
            success: function( response ) {
                if (response.success === true) {
                    if (response.data) {
                        $('.postBox-list .row').append(response.data);
                        $('#news-ajax-form input[name="ajax-page"]').val(parseInt(page) + 1);
                        if (parseInt(postnum) <= $(".postBox-list .postBox").length) {
                            $("#btnViewmoreNews").hide();
                        }
                        $('.loading-page').hide();
                        $('body').css("opacity", "1");
                    } else {
                        $('.loading-page').hide();
                        $('body').css("opacity", "1");
                    }
                }
                $('.loading-page').hide();
                $('body').css("opacity", "1");
            }
        });
    });

    $(".form-inputGroup__control .form-control").on('click', function (e) {
        $(this).closest(".form-inputGroup__control").find("label")
            .css({"transform": "translateY(calc(-100% - 10px))", "font-size": "0.6875rem"});
    });

    // call new
    offerSearchByStore();

})(jQuery);
