jQuery(function($) {
    $('.form-check [name="nav"]').on('change', function() {
        $('.form-check a').attr('href', $(this).find('option:selected').val());
    })
    $('.form-check [name="nav"]').trigger('change');
	/**
	 * Bootstrap
	 */
	$('[data-toggle="tooltip"]').tooltip();
	$('[data-toggle=popover]').popover({
		container: 'body',
		sanitize: false,
	    html: true, 
		content: function() {
        	return $('#' + $(this).data('id')).html();
        }
	});
	$('body').on('click', function (e) {
	    $('[data-toggle=popover]').each(function () {
	        if (!$(this).is(e.target) && $(this).has(e.target).length === 0 && $('.popover').has(e.target).length === 0) {
	            $(this).popover('hide');
	        }
	    });
	});
	$('.modal').on('show.bs.modal', function (e) {
        if (typeof (e.relatedTarget) != "undefined") {
            window.location.hash = $(e.relatedTarget).attr('href');
        } 
    });
    $('.modal').on('hide.bs.modal', function (e) {
        history.pushState("", document.title, window.location.pathname + window.location.search);
    });
	if(window.location.hash.indexOf('#modal-') !== -1) {
		$modal = $(window.location.hash);
		$modal.modal('show');
	}

	/**
	 * Modal review
	 */
	$('.modal-next').click(function(e) {
		e.preventDefault();
		var $modal = $(this).parents('.modal');
		$modal.modal('hide');
		if ( $modal.nextAll('.modal').first().length > 0 ) {
			$modal.nextAll('.modal').first().modal('show'); 
		} else {
			$modal.prevAll('.modal').last().modal('show');
		}
	});
	$('.modal-prev').click(function(e) {
		e.preventDefault();
		var $modal = $(this).parents('.modal');
		$modal.modal('hide');
		if ( $modal.prevAll('.modal').first().length > 0 ) {
			$modal.prevAll('.modal').first().modal('show'); 
		} else {
			$modal.nextAll('.modal').last().modal('show');
		}
	});
	
	/**
	 * Site header scroll
	 */
	if( $(window).scrollTop() > 0 ) {
		$('.site-header').addClass('scroll');
	}
	$(window).scroll(function() {
		if( $(this).scrollTop() > 0 ) {
			$('.site-header').addClass('scroll');
		} else { 
			$('.site-header').removeClass('scroll');
		}
	});

	/**
	 * Aside nav
	 */
	$('.aside-nav-toggler').on('click touchstart', function() {
		$('body').addClass('open-aside-nav').append('<div class="aside-overlay"></div>').css('overflow', 'hidden');
        return false;
	});
	$('body').on('click touchstart', '.aside-nav-closer, .aside-overlay', function(e) {
		e.stopPropagation();
		$('body').removeClass('open-aside-nav').css('overflow', '');
		$('.aside-overlay').remove();
        return false;
	});
	$('.aside-nav li.menu-item-has-children').on('click', function(e) {
		e.stopPropagation();
        $(this).siblings().removeClass('active').children('.sub-menu').slideUp(300);
		$(this).toggleClass('active').children('.sub-menu').slideToggle(300);
	});
	$('.aside-nav li.menu-item-has-children > a').on('click', function(e) {
		e.stopPropagation();
	});
	
	/**
	 * Booking
	 */
	$('body').on('click', function() {
		$('#site-booking').collapse('hide');
	});
	$('.site-booking').on('click', function(e) {
		e.stopPropagation();
	});
	$('.site-booking-closer').on('click', function() {
		$('#site-booking').collapse('hide');
	});
	
   /**
	 * Site slider
	 */   
	var $siteSlider = $('.site-slider'); 
    $siteSlider.find('.item').height($(window).height());
	if ( $(window).width() < 992 ) {
        $('.home .site-slider').on('init', function() {
    		$(this).find('.item').height($(window).height());
    	});
    } else {
        $('.home .site-slider').on('init', function() {
    		$(this).find('.item').height($(window).height()- 50);
    	});
    }
	$(window).resize(function() {
		if ( $(window).width() < 992 ) {
	       $('.home .site-slider .item').height($(window).height());
	    } else {
	       $('.home .site-slider .item').height($(window).height() - 50);
	    }
	});
    $siteSlider.on('init', function(e, slick) {
		$siteSlider.find('.slick-slide:first-child').addClass('slick-first');
    });
    
	$siteSlider.slick({
		slidesToShow: 1,
		slidesToScroll: 1,
		fade: true,
		speed: 800,
		autoplay: true,
		autoplaySpeed: 4000,
        focusOnSelect: true,
        pauseOnHover:false,
		dots: true,
		responsive: [
			{
				breakpoint: 991,
				settings: {
					arrows: false
				}
			},
            {
				breakpoint: 768,
				settings: {
					arrows: false,
                    dots: false
				}
			}, 
		]
	});

	/**
	 * Site video
	 */
	var videoSrc = $('.site-video iframe').attr('src');
	$('.site-video-toggler').on('click', function() {
		if ( $(this).hasClass('active') ) {
			$(this).removeClass('active');
			$(this).html('<i class="far fa-play-circle"></i>');
			$('.site-video iframe').attr('src', videoSrc + '&autoplay=0');
			$('.site-video').fadeOut();
		} else {
			$(this).addClass('active');
			$(this).html('<i class="far fa-pause-circle"></i>');
			$('.site-video iframe').attr('src', videoSrc + '&autoplay=1');
			$('.site-video').fadeIn();
		}
	});

	/**
	 * Home rooms
	 */
	$('.home-rooms').slick({
		slidesToScroll: 1,
		slidesToShow: 1,
		speed: 900,
		centerMode: true,
		centerPadding: '20%',
		prevArrow: '<button type="button" class="slick-prev"><i class="fas fa-chevron-left"></i></button>',
		nextArrow: '<button type="button" class="slick-next"><i class="fas fa-chevron-right"></i></button>',
		responsive: [
			{
				breakpoint: 767,
				settings: {
					centerPadding: '0',
				}
			}, 
		]
	});

	/**
	 * Home brands nav
	 */
	$('.home-brands-thumbs').slick({
		slidesToShow: 7,
		slidesToScroll: 1,
		speed: 300,
		autoplay: true,
		autoplaySpeed: 3000,
		arrows: false,
		focusOnSelect: true,
		centerMode: true,
		asNavFor: '.home-brands-images',
        responsive: [
			{
				breakpoint: 992,
				settings: {
                    slidesToShow: 5,
					arrows: false,
				}
			}, 
            {
				breakpoint: 768,
				settings: {
                    slidesToShow: 3,
					arrows: false,
				}
			}, 
		]
	});
	$('.home-brands-images').slick({
		slidesToShow: 1,
		slidesToScroll: 1,
		speed: 300,
		fade: true,
		asNavFor: '.home-brands-thumbs',
		arrows: false,
	});

	/**
	 * Standard category post gallery
	 */
	$('.std-cat-post-gallery, .std-post-gallery').slick({
		slidesToShow: 1,
		slidesToScroll: 1,
		speed: 600,
		dots: true,
		arrows: true,
        prevArrow: '<button type="button" class="slick-prev"><i class="fas fa-chevron-left"></i></button>',
		nextArrow: '<button type="button" class="slick-next"><i class="fas fa-chevron-right"></i></button>',
		infinite: false,
	});
	$('[data-toggle="tab"]').on('shown.bs.tab', function(event) {
		$('.std-cat-post-gallery, .std-post-gallery').slick('setPosition');
	});
	$('.slick-dots').each(function() {
		if ( $(this).find('li').length == 1 ) {
			$(this).remove();
		}
	});
	
	/**
	 * Fancybox
	 */
	$('[data-fancybox]').fancybox({
  		backFocus : false,
		youtube : {
			showinfo : 0
		},
		thumbs : {
			autoStart : true
		},
	});
	
	/**
	 * Form book
	 */
	$('[href^="#modal-"]').on('click', function() {
		$modal = $($(this).attr('href'));
		$modal.modal('show');
		$modal.find('.modal-title').text($(this).text());
		$modal.find('[name="book"]').val($(this).text());
		$modal.find('[name="page"]').val($(this).data('page'));
		$modal.find('.alert').remove();
	});
	if(window.location.hash.indexOf('#popup-info') !== -1) {
		$modal = $(window.location.hash);
		$modal.modal('show');
	}
	$('.form-book, .form-contact').on('submit', function(e) {
		e.preventDefault();	
		var $this = $(this);
		$this.find('.btn').append('<i class="fas fa-circle-notch fa-spin ml-2 icon"></i>');
		$this.find('.alert').remove();
		$.ajax({
			type: 'POST',
			url: ajax.ajax_url,
			data: $this.serialize(),
			success: function( data, textStatus, jqXHR ) {
				setTimeout(function() {
					$this.find('.btn').find('.icon').remove();
					if( data.status == false ) {
						$this.append('<div class="alert alert-danger">' + data.message + '</div>');
					} else {
						$this.find('.form-control').val('');
						$this.append('<div class="alert alert-success">' + data.message + '</div>');
					}
				}, 500);
			},
			error: function( jqXHR, textStatus, errorThrown ) {
				alert( jqXHR.responseText );
			}
		});
	});

	setTimeout(function() {
		$('.modal-booking .modal-body').html(bookingCode);
		$('body').append(customizerJs);
	}, 3000);
});