
document.querySelectorAll('.openPdfButton').forEach(button => {
    button.addEventListener('click', function () {
        var pdfUrl = this.getAttribute('data-pdf-url');

        // Clear previous PDF content
        var pdfContainer = document.getElementById('pdfContainer');
        pdfContainer.innerHTML = '';

        // Tải và render PDF
        var loadingTask = pdfjsLib.getDocument(pdfUrl);
        loadingTask.promise.then(function (pdf) {
            console.log('PDF loaded');

            // Lặp qua tất cả các trang và render
            for (var pageNumber = 1; pageNumber <= pdf.numPages; pageNumber++) {
                pdf.getPage(pageNumber).then(function (page) {
                    console.log('Page loaded');

                    var scale = 1.5;
                    var viewport = page.getViewport({ scale: scale });

                    // Prepare canvas using PDF page dimensions
                    var canvas = document.createElement('canvas');
                    canvas.className = 'pdf-canvas';
                    var context = canvas.getContext('2d');
                    canvas.height = viewport.height;
                    canvas.width = viewport.width;
                    pdfContainer.appendChild(canvas);

                    // Render PDF page into canvas context
                    var renderContext = {
                        canvasContext: context,
                        viewport: viewport
                    };
                    var renderTask = page.render(renderContext);
                    renderTask.promise.then(function () {
                        console.log('Page rendered');
                    });
                });
            }
        }, function (reason) {
            console.error(reason);
        });

        $('#pdfModal').modal('show');
    });
});