(function ($) {
  "use strict";

  function fullpage(status) {
		if (!status) {
			if ($(window).width() > 991) {
				$("#fullpage").fullpage({
					scrollingSpeed: 1500,
					css3: !0,
					easingcss3: "cubic-bezier(0.77, 0, 0.175, 1)",
					navigation: !1,
					lockAnchors: !0,
					fitToSection: !0,
					scrollOverflow: !0,
					scrollOverflowOptions: {
						probeType: 3
					},
					loopBottom: !1,
          afterLoad: function(anchorLink,index) {
            var tmax = new TimelineMax();
						tmax.to(".section.active .effect-up-level-1", 0.8, {
							y: -15,
							autoAlpha: 1,
							ease: Power1.easeInOut
						}).to(".section.active .effect-up-level-2", 0.5, {
							y: -15,
							autoAlpha: 1,
							ease: Power1.easeInOut
						}, "0.2").to(".section.active .effect-up-level-3", 0.5, {
							y: -30,
							autoAlpha: 1,
							ease: Power1.easeInOut
						}, "0.4");
            

            var xlmax = new TimelineMax();
            xlmax.to(".section.active .effect-left-level-1", 0.8, {
							x: -45,
							autoAlpha: 1,
							ease: Power1.easeInOut
						})

            // event scroll last section
            // if (index === $('#fullpage .section').length) {
            //   $.fn.fullpage.setScrollOverflow = false;
            //   $.fn.fullpage.reBuild()
            //   console.log('last')
            // }
            $(document).scroll(function() {
              var last_section = $('#fullpage').find('.section').last();
              var offset = last_section.offset();
              var w = $(window);
              if (offset.top - w.scrollTop() > 0) {
                $.fn.fullpage.setScrollOverflow = true;
                $.fn.fullpage.reBuild()
              }
            })

            // service slider
            // if (index == 3) {
            //   var serviceSwiper = new Swiper('#service-slider', {
            //     slidesPerView: 1,
            //     spaceBetween: 0,
            //     autoplay: true,      
            //     speed: 5000,
            //     loop: false,
            //     navigation: {
            //       nextEl: '#service-slider .swiper-button-next',
            //       prevEl: '#service-slider .swiper-button-prev',
            //     }
            //   });
            // }

            // if (index==5) {
            //   var offersSwiperCatz = new Swiper(".slider-offers-catz", {
            //     slidesPerView: 1,
            //     spaceBetween: 0,
            //     navigation: {
            //       nextEl: ".offers-catz-container .swiper-button-next",
            //       prevEl: ".offers-catz-container .swiper-button-prev",
            //     },
            //   });
            // }
          },
          onLeave: function(index, nextIndex, direction) {
						var tmax = new TimelineMax();
						tmax.to("section.active .effect-up-level-1", 0.8, {
							y: 0,
							autoAlpha: 0,
							ease: Power1.easeInOut
						}).to("section.active .effect-up-level-2", 0.5, {
							y: 0,
							autoAlpha: 0,
							ease: Power1.easeInOut
						}, "0.2").to("section.active .effect-up-level-3", 0.5, {
							y: 0,
							autoAlpha: 0,
							ease: Power1.easeInOut
						}, "0.4").to("section.active .effect-left-level-1", 0.8, {
							x: 0,
							autoAlpha: 0,
							ease: Power1.easeInOut
						});
					}
				})        
			} else {}
		} else {
			$.fn.fullpage.reBuild()
		}
	}

  function heightSlider() {
    // Optional: Set dynamic min-height based on the content slides
    if ($('.slider-offers').length > 0) {
      var slides = document.querySelectorAll('.slider-offers .swiper-slide');
      var maxHeight = 0;

      slides.forEach(function (slide) {
        var height = slide.scrollHeight;
        if (height > maxHeight) {
          maxHeight = height;
        }
      });

      slides.forEach(function (slide) {
        slide.style.minHeight = maxHeight + 'px';
      });
    }
  }

  $(window).ready(function () {
    $('.btn-back-top').click(function(){
      // $('html, body').animate({scrollTop: 0}, "smooth");
      $('html, body').scrollTop(0);
      
    });

    $('.section .btn-back-top').on('click', function() {
      $.fn.fullpage.moveTo(1); // Scroll to the first section
    });

    $('.btn-open-menu').click(function(){
      $('.sidebar-menu').addClass('show');
      $('body').addClass('body-hidden');
      $.fn.fullpage.setAllowScrolling(false);
    });

    $('.btn-close-menu').click(function(){
      $('.sidebar-menu').removeClass('show');
      $('body').removeClass('body-hidden');
      $.fn.fullpage.setAllowScrolling(true);
    });
    
    // new WOW().init();
   
    $('.custom-nice-select select').niceSelect();

    var serviceSwiper = new Swiper('#service-slider', {
      slidesPerView: 1,
      spaceBetween: 0,
      autoplay: true,      
      speed: 5000,
      loop: true,
      navigation: {
        nextEl: '#service-slider .swiper-button-next',
        prevEl: '#service-slider .swiper-button-prev',
      },
    });

    var offersSwiperCatz = new Swiper(".slider-offers-catz", {
      slidesPerView: 1,
      spaceBetween: 0,
      navigation: {
        nextEl: ".offers-catz-container .swiper-button-next",
        prevEl: ".offers-catz-container .swiper-button-prev",
      },
    });

    var offersSwiper = new Swiper(".slider-offers", {
      slidesPerView: 1,
      spaceBetween: 0,
      speed: 5000,
      autoplay: true,
      loop: true,
      navigation: {
        nextEl: ".slider-offers .swiper-button-next",
        prevEl: ".slider-offers .swiper-button-prev",
      },
      on: {
        init: function () {
          setEqualHeightAfterImagesLoad();
        },
        resize: function () {
          setEqualHeightAfterImagesLoad();
        },
      },
    });

    function setEqualHeightAfterImagesLoad() {
      var images = document.querySelectorAll('.slider-offers .swiper-slide img');
      var imagesLoaded = 0;

      if (images.length === 0) {
        setEqualHeight();
        return;
      }

      images.forEach(function (img) {
        if (img.complete) {
          imagesLoaded++;
          if (imagesLoaded === images.length) {
            setEqualHeight();
          }
        } else {
          img.onload = function () {
            imagesLoaded++;
            if (imagesLoaded === images.length) {
              setEqualHeight();
            }
          };
          img.onerror = function () {
            imagesLoaded++;
            if (imagesLoaded === images.length) {
              setEqualHeight();
            }
          };
        }
      });
    }

    function setEqualHeight() {
      var maxHeight = 0;
      var slides = document.querySelectorAll('.slider-offers .swiper-slide');
      slides.forEach(function (slide) {
        slide.style.height = 'auto'; // Reset height
        var img = slide.querySelector('img');
        if (img) {
          img.style.height = 'auto'; // Reset image height if it exists
        }
      });

      slides.forEach(function (slide) {
        maxHeight = Math.max(maxHeight, slide.offsetHeight);
      });

      slides.forEach(function (slide) {
        slide.style.height = maxHeight + 'px';
        var img = slide.querySelector('img');
        if (img) {
          img.style.height = maxHeight + 'px'; // Set image height if it exists
        }
      });
    }
    // heightSlider(); 

    var meetingSlider = new Swiper(".meetingSlider", {
      slidesPerView: 1,
      spaceBetween: 0,
      speed: 2000,
	  autoplay: {
			delay: 7000,
	  },
      loop: true,
      navigation: {
        nextEl: ".meeting-menu-box .swiper-button-next",
        prevEl: ".meeting-menu-box .swiper-button-prev",
      },
    });

    var floorSwiper = new Swiper(".floorSwiper", {
      slidesPerView: "auto",
      loop: false,
      navigation: {
        nextEl: ".floorSwiper .swiper-button-next",
        prevEl: ".floorSwiper .swiper-button-prev",
      },
      breakpoints: {
        0: {
          slidesPerView: 1,
          spaceBetween: 48,
        },
        992: {
          spaceBetween: 24,
          slidesPerView: "auto",
        },
        1200: {
          spaceBetween: 48,
          slidesPerView: "auto",
        },
      },
    });

    var floorSwiperNav = new Swiper(".floorSwiperNav", {
      spaceBetween: 22,
      slidesPerView: 1,
      freeMode: true,
      watchSlidesProgress: true,
      variableWidth: true,
      speed: 1500,
      loop: true,
    });

    var floorSwiperMain = new Swiper(".floorSwiperMain", {
      spaceBetween: 0,
      loop: true,
      navigation: {
        nextEl: ".wrap-slider .swiper-button-next",
        prevEl: ".wrap-slider .swiper-button-prev",
      },
      thumbs: {
        swiper: floorSwiperNav,
      },
      speed: 1500
    });

    var tabsSlider = new Swiper(".tabsSlider", {
      slidesPerView: 3,
      loop: false,
      navigation: {
        nextEl: ".group-btns-slider-tab .swiper-button-next",
        prevEl: ".group-btns-slider-tab .swiper-button-prev",
      },
      clickable: true,
      breakpoints: {
        0: {
          slidesPerView: 2,
          spaceBetween: 8,
        },
        992: {
          spaceBetween: 24,
          slidesPerView: 3,
        },
        1200: {
          spaceBetween: 24,
          slidesPerView: 2.5,
        },
      },
    });

    // about - page
      var slideIntroSpace = new Swiper(".slide_intro_space", {
          slidesPerView: 1,
          loop: false,
          navigation: {
              nextEl: ".group-btns-slider-tab .swiper-button-next",
              prevEl: ".group-btns-slider-tab .swiper-button-prev",
          },
          clickable: true,
          breakpoints: {
              767: {
                  slidesPerView: 2,
              },
              992: {
                  slidesPerView: 3,
              },
              1200: {
                  slidesPerView: 3,
              },
          },
      });

      var aboutFacilitiesThumb = new Swiper(".sec_about_facilities .slide_content", {
          spaceBetween: 22,
          slidesPerView: 1,
          freeMode: true,
          watchSlidesProgress: true,
          variableWidth: true,
          speed: 1500,
          loop: true,
          navigation: {
            nextEl: ".sec_about_facilities .swiper-button-next",
            prevEl: ".sec_about_facilities .swiper-button-prev",
          },
      });

      var aboutFacilitiesMain = new Swiper(".sec_about_facilities .slide_img", {
          spaceBetween: 0,
          loop: true,
          navigation: {
              nextEl: ".wrap-slider .swiper-button-next",
              prevEl: ".wrap-slider .swiper-button-prev",
          },
          thumbs: {
              swiper: aboutFacilitiesThumb,
          },
          speed: 1500,
          on: {
              slideChange: function () {
                  aboutFacilitiesThumb.slideTo(this.realIndex);
              }
          }
      });

// Hoặc ngược lại - thumb điều khiển main
      aboutFacilitiesThumb.on('slideChange', function () {
          aboutFacilitiesMain.slideTo(this.realIndex);
      });

    $('.nav-tab-block').on('click',function(){
      var img = $(this).attr('data-img');
      console.log(img);
      $('.section-tabs').css({
        'background-image': img
      })
    })

    var meetingSetupSwiper = new Swiper(".meetingSetupSwiper", {
      slidesPerView: 2.3,
      spaceBetween: 24,
      breakpoints: {
        0: {
          slidesPerView: 3,
          spaceBetween: 10,
        },
        768: {
          slidesPerView: 2.3,
          spaceBetween: 24,
        },
        1024: {
          slidesPerView: 2.3,
          spaceBetween: 24,
        },
      }
    });   


    $('.venues-box').mouseenter(function() {
      $(this).addClass("hover");
      $('.venues-contents').addClass('is-hover');
    }).mouseleave(function () {
      $(this).removeClass("hover");
      $('.venues-contents').removeClass('is-hover');
    });

    var bannerSwiper = new Swiper(".bannerSwiper", {
      slidesPerView: 1,
      autoplay: true,
      speed: 7000,
      loop: true,
      // effect: "fade",
    });

    $(".gallery-link").click(function() {
        $.fancybox.open([
          {
              src  : 'images/upload/img-demo-1-thumb.png',
              opts : {
                caption : '',
                thumb   : 'images/upload/img-demo-1-thumb.png'
              }
          },
          {
              src  : 'images/upload/img-demo-2.png',
              opts : {
                caption : '',
                thumb   : 'images/upload/img-demo-2-thumb.png'
              }
          },
          {
            src  : 'images/upload/img-demo-3.png',
            opts : {
              caption : '',
              thumb   : 'images/upload/img-demo-3-thumb.png'
            }
          },
          {
              src  : 'images/upload/img-demo-4.png',
              opts : {
                caption : '',
                thumb   : 'images/upload/img-demo-4-thumb.png'
              }
          },
          
          ], {
          loop : false,
          thumbs : {
            autoStart : true,
            axis      : 'x'
          },
          toolbar         : true,
          infobar         : false,
          clickContent    : false,
          arrows: false,
          afterLoad : function( instance, current ) {
            if ( instance.group.length > 1 && current.$content ) {
              current.$content.append('<a data-fancybox-next class="fancybox-navigation-button-next" href="javascript:;">&nbsp;</a><a data-fancybox-prev class="fancybox-navigation-button-previous" href="javascript:;">&nbsp;</a>');
            }
          },
          baseTpl:
            '<div class="fancybox-container" role="dialog" tabindex="-1">' +
              '<div class="fancybox-bg"></div>' +
              '<div class="fancybox-inner">' +
                // '<div class="fancybox-stage"><div class="fancybox-navigation">{{arrows}}</div></div>' +
                '<div class="fancybox-stage"></div>' +
                '<div class="fancybox-caption-wrap"><div class="fancybox-caption"></div></div>' +
                '<div class="fancybox-toolbar">{{buttons}}</div>'+
              "</div>" +
            "</div>",

        });
        return false;
    });


    fullpage();

    $('.nav-pills-cs .nav-link').on('click', function(){
      var cur = $(this).attr('id');
      $('.desc-item.active').removeClass('active');
      $('.desc-item').each(function(){
        var descTagert = $(this).attr('data-bs-target');
        if (descTagert === cur) {
          $(this).addClass('active');
        }
      })
    })
    
    // turn off fullpage when scroll    
    $('#pdfModal').on('show.bs.modal', function () {
      if ($(window).width() >= 992) {
        $.fn.fullpage.setAllowScrolling(false);
      }
      meetingSlider.autoplay.stop();
    });

    $('#pdfModal').on('hidden.bs.modal', function () {
      if ($(window).width() >= 992) {
        $.fn.fullpage.setAllowScrolling(true);
      }
      meetingSlider.autoplay.start();
  });

  });

  $(window).on("load",function(){
    $(".news-list-view .scrollable-news-2").mCustomScrollbar();
    var scroll = '-' + $('.scrollable-news-1').height()/3 + 'px';
    $('.scrollable-news-1').mCustomScrollbar({
      setTop: scroll
    });


    // $('.service-item .card-info-text').mCustomScrollbar();
    // scrollableViewMd();
    // scrollableViewLg();
    // $('.block-text .desc').mCustomScrollbar();
    // $('.meeting-text').mCustomScrollbar();
    // $('.packages-summary').mCustomScrollbar();
    // $('.meeting-menu-box-desc').mCustomScrollbar();
    // fixHeightSliderVenue();
  });
  
  // scrollbar
  function scrollableViewLg() {
    if($(window).width() > 991) {
      $('.news-box .desc').mCustomScrollbar();
      $('.floor-plan-desc').mCustomScrollbar();
    }
  }
  
  // scrollbar
  function scrollableViewMd() {
    if($(window).width() > 767) {
      $('.section-venue-context-inner .wrap-text').mCustomScrollbar();
    }
  }

  // height
  function fixHeightSliderVenue() {
    if($(window).width() > 991) {
      var heightSection = $('.section-floor-plan').height();
      var heightHeading = $('.section-floor-plan .group-heading').height();
      var headingDescBottom = $('.floor-plan-desc-bottom').height();
      // fix css: 100px paddingTop, 60px marginBottomHeading
      // 100 distanceBottom from slide to bottomSection
      var heightSlider = heightSection - heightHeading - headingDescBottom - 100 - 60;
      $('.wrap-slider').css("height", heightSlider + "px");
    } else {
      $('.wrap-slider').css("height", "auto");
    }
  }
 

  $(window).scroll(function() {});
  // **********************************************************************//
  // ! Window resize
  // **********************************************************************//
  $(window).resize(function() {
		if ($(window).width() < 992) {
			$.fn.fullpage.destroy("all")
		}
    // fixHeightSliderVenue();
    // heightSlider();
	});
})(jQuery);