jQuery(document).ready(function(){
    loadMoreSearch();
})

function loadMoreSearch(){
    jQuery(document).delegate(".load-more-search", "click", function(e){
        e.preventDefault();

        var thisBtn = jQuery(this),
            max = thisBtn.data("max"),
            page = thisBtn.data("page"),
            postType = thisBtn.data("post-type"),
            limit = thisBtn.data("limit"),
            search = thisBtn.data("search");


        jQuery.ajax({
            url: `${nk.ajax_url}?action=load_more_search`,
            method: "POST",
            data:{
                page : page,
                postType : postType,
                limit : limit,
                search : search,
            },
            beforeSend: function(){
                thisBtn.addClass("btn-loading");
            }
        }).done(function(respond){
            jQuery(".search-tab-content.tab-"+postType+" .search-grid").append(respond.html);
            page++;
            if(page > max){
                thisBtn.remove();
            }
            else{
                thisBtn.data("page", page);
            }
        }).fail(function(error){

        }).always(function(){
            thisBtn.removeClass("btn-loading");
        })
   })
}