(function($) {
  'use strict';
	$(function(e) {
		
	
		jQuery(document).ready(function($) {
     	var $description = $(".svg-maker-tooltip");
	        $('#masterplain .item-maker').hover(function() {
	            $(this).addClass("active");
	            $description.addClass('active');
	            $description.html($(this).data('title'));
	    }, function() {
	        $(this).removeClass("active");
	        $description.removeClass('active');
	    });

      $("#masterplain .inner").on('click', 'li', function(event) {
      	var isActive = false;
      	if($(this).hasClass("active")){
      		isActive = true;
      	}
      	var parent = $(this).closest(".tab-pane");
	    	var key= $(this).data("key");
	    	$(".item-maker circle",parent).removeClass("animated growIn go");
	    	$(".item-maker text",parent).removeClass("animated growIn go");
	    	$(".item-maker[data-key='"+key+"'] circle",parent).addClass("animated growIn go");
	    	$(".item-maker[data-key='"+key+"'] text",parent).addClass("animated growIn go");

	    	$('#masterplain .item-maker').removeClass("active");
	    	$("#masterplain .inner li").removeClass("active");

	    	if(!isActive){
	    		$(".item-maker[data-key='"+key+"']").addClass("active");
	    		$(this).addClass("active");
	    	}

	    	return false;
	    });

	    $(document).on('mousemove', function(e){
	      $description.css({
	        left:  e.pageX,
	        top:   e.pageY - 60
	      });
	      
	    });

	    if($(".section-content-gallery .items").length>0){
	    	$(".section-content-gallery .items").each( function(index, val) {
	    		if($(this).hasClass("d-autoload")){
	    			return;
	    		}
	    		var $control = $(this).next();
	    		var $setting = $(this).data("slick");
	    		var $slidesToShow = $setting && $setting.slidesToScroll ? $setting.slidesToScroll:3;
	    		var $slidesToScroll = $setting && $setting.slidesToScroll ? $setting.slidesToScroll:3;

    		 	$(this).slick({
	          infinite: false,
	          dots: true,
	          arrows:true,
	          slidesToShow: $slidesToShow,
	          speed: 300,
	          slidesToScroll: $slidesToScroll,
	          responsive:[
	            {
	              breakpoint: 1024,
	              settings: {
	                slidesToShow: 2,
	                slidesToScroll: 2,
	              }
	            },
	            {
	              breakpoint: 480,
	              settings: {
	                slidesToShow: 1,
	                slidesToScroll: 1,
	                rows: 1
	              }
	            }
	          ],
	          nextArrow: $('.next', $control),
	          prevArrow: $('.prev', $control),
	          appendDots: $('.dots', $control)
	        }).removeClass("d-none");
	    	});
        
      }

      if($("#partner .items").length>0){
	    	$("#partner .items").each( function(index, val) {
	    		var $control = $(this).next();
	    		var $setting = $(this).data("slick");
	    		var $slidesToShow = $setting && $setting.slidesToScroll ? $setting.slidesToScroll:5;
	    		var $slidesToScroll = $setting && $setting.slidesToScroll ? $setting.slidesToScroll:5;

    		 	$(this).slick({
	          infinite: false,
	          dots: true,
	          arrows:true,
	          slidesToShow: $slidesToShow,
	          speed: 300,
	          slidesToScroll: $slidesToScroll,
	          responsive:[
	            {
	              breakpoint: 480,
	              settings: {
	                slidesToShow: 2,
	                slidesToScroll: 2
	              }
	            }
	          ],
	          nextArrow: $('.next', $control),
	          prevArrow: $('.prev', $control),
	          appendDots: $('.dots', $control)
	        }).removeClass("d-none");
	    	});
        
      }
      if($("#furniture .items").length>0){
	    	$("#furniture .items").each( function(index, val) {
	    		var $control = $(this).next();
	    		var $ethis = $(this);
    		 	$ethis.slick({
	          infinite: false,
	          dots: true,
	          arrows:true,
	          slidesToShow: 1,
	          speed: 300,
	          nextArrow: $('.next', $control),
	          prevArrow: $('.prev', $control),
	          appendDots: $('.dots', $control)
	        }).removeClass("d-none");

    		 	$('#furniture .category a').on('click', function() {
					    var filterClass = $(this).data('value')
					    $ethis.slick('slickUnfilter')
					    $ethis.slick('slickFilter', filterClass)
					});
					$('#furniture .category a').first().trigger("click");
	    	});
      } 

      //Fancy Trigger
      $(".fancy-trigger").click(function(event) {
      	var target = $(this).data("target");
      	$(target).first().trigger('click');
      });

      //Tab trigger
      $(".tab-select-trigger").change(function(event) {
      	 event.stopPropagation();
      	var v= $(this).val();
      	var next= $(this).next();
      	if($("a[data-bs-target='#"+v+"']",next).length>0){
      			$("a[data-bs-target='#"+v+"']",next)[0].click();
      	}
      });
         
    });
	
		
		/*facility map*/

		var facilityMaker =[];
		function updateFacilityMap(group) {
			$("#facility .inner .items").html("");
			facilityMaker=[];
			$("#facility .facility-maker .item-maker").addClass("d-none");
			$("#facility .facility-maker .item-maker[data-group='"+group+"']").removeClass("d-none");			
			$("#facility .facility-maker .item-maker[data-group='"+group+"']").each(function(index, val) {
				facilityMaker.push(this);
				 var number = $("text",this).text();
				 var title = $(this).data("title");
				 var $li = $("<li data-index='"+index+"'><span>"+number+"</span> "+title+"</li>");
				 $(this).click(function(event) {
				 		$("#facility .inner .items li").removeClass("animated shake go active"); //wiggle
				 		$li.addClass("animated shake go active");
				 });
				 $("#facility .inner .items").append($li);
			});

		}
		$("#facility .category .item").click(function(event) {
			$("#facility .category .item").removeClass("active");
			$(this).addClass("active");
				var group= $(this).data("id");
				updateFacilityMap(group);

				return false;
		});
		$("#facility .category select").change(function(event) {
			var group= $(this).val();
			updateFacilityMap(group);
		});

		$("#facility .category .item").first().trigger("click");

		jQuery(window).load(function() {
		    var elem = document.getElementById('panzoom-element');
        var zoomInButton = document.getElementById('zoom-in');
        var zoomOutButton = document.getElementById('zoom-out');
        var resetButton = document.getElementById('reset');
        var panzoom = Panzoom(elem,{
        	maxScale: 5,
					minScale: 1,
					panOnlyWhenZoomed:true,
        	beforeWheel: function(e) {
				    // allow wheel-zoom only if altKey is down. Otherwise - ignore
				    var shouldIgnore = !e.altKey;
				    return shouldIgnore;
				  },
        	onTouch: function(e) {
					    return false; // tells the library to not preventDefault.
				  }
        });
        var parent = elem.parentElement
		    // No function bind needed
		    parent.addEventListener('wheel', panzoom.zoomWithWheel);
		    zoomInButton.addEventListener('click', panzoom.zoomIn)
		    zoomOutButton.addEventListener('click', panzoom.zoomOut)
		    resetButton.addEventListener('click', panzoom.reset)

		    $("#facility .inner").on('click', 'li', function(event) {
		    	var index= $(this).data("index");
		    	var m= facilityMaker[index];
		    	$("#facility .facility-maker .item-maker rect, #facility .facility-maker .item-maker text").removeClass("animated growIn go");
		    	//console.log($(m).data("x"));
		    	var panzoomW = $("#panzoom-element").width();
		    	var panzoomParentW = $(".panzoom-parent").data("width") / 2;
		    	var panzoomParentH = $(".panzoom-parent").data("height") / 2;
		    	var r = $("#panzoom-element").width() / $(".panzoom-parent").data("width");
		    	var rh = $("#panzoom-element").height() / $(".panzoom-parent").data("height");

		    	var x = 0; var y=0;
		    	var mx = $(m).data("x");
		    	var my = $(m).data("y");
		    	
		    	if(panzoomParentW > mx){
		    		x= panzoomParentW - mx - 16;
		    	}
		    	else{
		    		x= panzoomParentW - mx - 16;
		    	}	

		    	y= panzoomParentH - my;
		    	if(panzoomParentH > my){
		    		y= panzoomParentH - my - 16;
		    	}
		    	else{
		    		y= panzoomParentH - my - 16;
		    	}		


		    	panzoom.pan(x*r, y*rh);
		    	panzoom.zoom(2,{ animate: true });
		    	$("rect, text",m).addClass("animated growIn go");

		    	
		    });
		    

		});
		
		
	});
})(jQuery);
