Number.prototype.format = function(n, x, s, c) {
    var re = '\\d(?=(\\d{' + (x || 3) + '})+' + (n > 0 ? '\\D' : '$') + ')',
        num = this.toFixed(Math.max(0, ~~n));

    return (c ? num.replace('.', c) : num).replace(new RegExp(re, 'g'), '$&' + (s || ','));
};


( function($) {
  'use strict';
  $(function(e) {
    

    $(window).resize(function(event) {
      calcBannerSize();
    });
    
    calcBannerSize();

    function calcBannerSize(){
        var h = $(window).width() * 980 / 1920 ;
        if($(window).width()>=1200 ){
          h = $(window).height() - $("#header").height();
        }
        $("#page_banner .section-content").css('height',h);
        $("#intro_section").css('height',h);

    }
    
    /*-------------------------------------------------------------------------------
        Sticky-Header
      -------------------------------------------------------------------------------*/
      function triggerSticky(){
        var sticky = $('#header'),
          scroll = $(window).scrollTop();

        if (scroll >= $("#header #navbar").position().top && scroll >=1){
          sticky.addClass('sticky');
          $("#gotop").removeClass('d-none');
        } 
        else{
          sticky.removeClass('sticky');
          $("#gotop").addClass('d-none');
        } 
      }
    $(window).scroll(function(){
        triggerSticky();
    });
    triggerSticky();

    if($("body").hasClass('home-page')){
        var hash = location.hash;
        if($("#header .navbar-nav a[href='"+hash+"']").length >0 ){
            $("#header .navbar-nav a[href='"+hash+"']").parent().addClass('active');
        }
        else{
            //console.log("dsds");
            $(".navbar-nav li:first-child").addClass('active');
        }
    }
    
    if($("body").hasClass('home-page')){
        var hash = location.hash;
        if($(".header .navbar-nav a[href='"+hash+"']").length >0 ){
            $("header .navbar-nav a[href='"+hash+"']").trigger('click').parent().addClass('active');
        }
        else{
            $("header .navbar-nav li:first-child").addClass('active');
        }
    }

    


    $('body').on('click',function(event){
      //console.log(event.target);
       if(!$(event.target).is('#navbarContent') 
        && !$(event.target).is('.navbar-toggler') 
        && !$(event.target).is('.navbar-toggler .navbar-toggler-icon') 
        && !$(event.target).parent().is('.menu-item-has-children')
        && $(".offcanvas-collapse").hasClass('open') ){
         $('.offcanvas-collapse').removeClass('open');
       }
    });

    $("#gotop").click(function(event) {
      if(!$("#fullpage").hasClass('fullpage-wrapper')){
        //var target = $(this).attr('href').substring(1);
        $([document.documentElement, document.body]).animate({
              //scrollTop: $("section[data-anchor='"+target+"']").offset().top
              scrollTop:0
        }, 500);
        return false;
      }
      
    });


    $("[data-trigger]").on("click", function(e){
        e.preventDefault();
        e.stopPropagation();
        var offcanvas_id =  $(this).attr('data-trigger');
        $(offcanvas_id).toggleClass("show");
        $('body').toggleClass("offcanvas-active");
        $(".screen-overlay").toggleClass("show");
    }); 

    // Close menu when pressing ESC
    $(document).on('keydown', function(event) {
        if(event.keyCode === 27) {
           $(".mobile-offcanvas").removeClass("show");
           $("body").removeClass("overlay-active");
        }
    });

    $(".btn-close, .screen-overlay").click(function(e){
      $(".screen-overlay").removeClass("show");
        $(".mobile-offcanvas").removeClass("show");
        $("body").removeClass("offcanvas-active");
    }); 



     $('.dropdown-toggle').dropdown();


     $(".js__toggle-menu").click(function () {
      $("header").toggleClass("open");
      return false;
    });
    $(".parent-width-child").each(function () {
      var $child = $(this);
      var $parent = $(this).closest(".parent-width-parent");
      $child.width($parent.width());
      $(window).resize(function () {
        $child.width($parent.width());
      });
    });
    $("header .navbar-nav li a").click(function () {
      $("header").removeClass("open");
    });



    $(".navbar-nav li a, .btn-scroll").click(function(event) {
      //if($("body").hasClass('home-page') && $(window).width()<=responsiveWidth ){
        var target = $(this).attr('href').substring(1);
        if($("section[data-anchor='"+target+"']").length>0){
          $([document.documentElement, document.body]).animate({
              scrollTop: $("section[data-anchor='"+target+"']").offset().top - 30
          }, 500, function(){
            //$("#header .dual-collapse2").collapse("hide");
          });  
          return false;
        }
        
      //}
    });


    $(".fancy-iframe a").click(function(event) {
      var link = $(this).attr('href');
      $.fancybox.open({
        src  : link,
        type : 'iframe',
         width  : '95%',
        height : '95%',
      });
      return false;
    });


    var styleMap = [
        { elementType: "geometry", stylers: [{ color: "#f5f5f5" }] },
        { elementType: "labels.icon", stylers: [{ visibility: "off" }] },
        { elementType: "labels.text.fill", stylers: [{ color: "#616161" }] },
        { elementType: "labels.text.stroke", stylers: [{ color: "#f5f5f5" }] },
        { featureType: "administrative.land_parcel", elementType: "labels.text.fill", stylers: [{ color: "#bdbdbd" }] },
        { featureType: "poi", elementType: "geometry", stylers: [{ color: "#eeeeee" }] },
        { featureType: "poi", elementType: "labels.text.fill", stylers: [{ color: "#757575" }] },
        { featureType: "poi.park", elementType: "geometry", stylers: [{ color: "#e5e5e5" }] },
        { featureType: "poi.park", elementType: "labels.text.fill", stylers: [{ color: "#9e9e9e" }] },
        { featureType: "road", elementType: "geometry", stylers: [{ color: "#ffffff" }] },
        { featureType: "road.arterial", elementType: "labels.text.fill", stylers: [{ color: "#757575" }] },
        { featureType: "road.highway", elementType: "geometry", stylers: [{ color: "#dadada" }] },
        { featureType: "road.highway", elementType: "labels.text.fill", stylers: [{ color: "#616161" }] },
        { featureType: "road.local", elementType: "labels.text.fill", stylers: [{ color: "#9e9e9e" }] },
        { featureType: "transit.line", elementType: "geometry", stylers: [{ color: "#e5e5e5" }] },
        { featureType: "transit.station", elementType: "geometry", stylers: [{ color: "#eeeeee" }] },
        { featureType: "water", elementType: "geometry", stylers: [{ color: "#c9c9c9" }] },
        { featureType: "water", elementType: "labels.text.fill", stylers: [{ color: "#9e9e9e" }] },
    ];

    $("[data-location]").each(function () {
        var data = $(this).data("location").split(",");
        if (data.length) {
            var mapPoints = [{ lat: parseFloat(data[0]), lng: parseFloat(data[1]), info: { title: "", link: "", thumb: "", price: "" } }];
            funcMap(mapPoints, this);
        }
    });
    function funcMap(mapPoints, mapEl) {
        var centerMap = { lat: mapPoints[0].lat, lng: mapPoints[0].lng };
        var map = new google.maps.Map(mapEl, { center: centerMap, zoom: 13, styles: styleMap });
        var marker = new google.maps.Marker({
            position: centerMap,
            title: mapPoints[0].title,
            map: map,
            animation: google.maps.Animation.DROP,
            draggable: !1,
            icon: { url: template_directory + "/images/icon-map.svg", size: new google.maps.Size(38, 38), origin: new google.maps.Point(0, 0) },
        });
    }

    
    
  
  });
})(jQuery);