jQuery(document).ready(function () {
    AOS.init({
        // Global settings:
        disable: false, // accepts following values: 'phone', 'tablet', 'mobile', boolean, expression or function
        startEvent: 'DOMContentLoaded', // name of the event dispatched on the document, that AOS should initialize on
        initClassName: 'aos-init', // class applied after initialization
        animatedClassName: 'aos-animate', // class applied on animation
        useClassNames: false, // if true, will add content of `data-aos` as classes on scroll
        disableMutationObserver: false, // disables automatic mutations' detections (advanced)
        debounceDelay: 50, // the delay on debounce used while resizing window (advanced)
        throttleDelay: 99, // the delay on throttle used while scrolling the page (advanced)


        // Settings that can be overridden on per-element basis, by `data-aos-*` attributes:
        offset: 120, // offset (in px) from the original trigger point
        delay: 300, // values from 0 to 3000, with step 50ms
        duration: 400, // values from 0 to 3000, with step 50ms
        easing: 'ease', // default easing for AOS animations
        once: true, // whether animation should happen only once - while scrolling down
        mirror: false, // whether elements should animate out while scrolling past them
        anchorPlacement: 'top-bottom', // defines which position of the element regarding to window should trigger the animation

    });
    tien_ich()
    menu_header()
    swipper_slider()
    CRsite_loading();
    CRsite_loading_svg();
    jQuery('.axome-tooltip').hide();
    hover_popup_image_map()
    jQuery(function() {
        jQuery('.map').maphilight();
    });

    // jQuery("img[usemap]").mapTrifecta();
    add_fullpage()

});

function swipper_slider(){
    var menu = [];
    jQuery('.hero-slider .swiper-slide').each( function(index){
        menu.push( jQuery(this).find('.hero-slider .slide-inner').attr("data-text") );
    });
    var interleaveOffset = 0.5;
    var swiperOptions = {
        loop: true,
        speed: 1000,
        parallax: true,


        pagination: {
            el: '.swiper-pagination',
            clickable: true,
        },
        navigation: {
            nextEl: ".swiper-button-next",
            prevEl: ".swiper-button-prev",
        },
        autoplay: {
            delay: 6000,
            disableOnInteraction: false,
        },
        watchSlidesProgress: true,
        on: {
            progress: function() {
                var swiper = this;
                for (var i = 0; i < swiper.slides.length; i++) {
                    var slideProgress = swiper.slides[i].progress;
                    var innerOffset = swiper.width * interleaveOffset;
                    var innerTranslate = slideProgress * innerOffset;
                    swiper.slides[i].querySelector(".hero-slider .slide-inner").style.transform =
                        "translate3d(" + innerTranslate + "px, 0, 0)";
                }
            },

            touchStart: function() {
                var swiper = this;
                for (var i = 0; i < swiper.slides.length; i++) {
                    swiper.slides[i].style.transition = "";
                }
            },

            setTransition: function(speed) {
                var swiper = this;
                for (var i = 0; i < swiper.slides.length; i++) {
                    swiper.slides[i].style.transition = speed + "ms";
                    swiper.slides[i].querySelector(".hero-slider .slide-inner").style.transition =
                        speed + "ms";
                }
            }
        }
    };

    var swiper = new Swiper(".hero-slider .swiper-container", swiperOptions);


    // DATA BACKGROUND IMAGE
    var sliderBgSetting = jQuery(".hero-slider .slide-bg-image");
    sliderBgSetting.each(function(indx){
        if (jQuery(this).attr("data-background")){
            jQuery(this).css("background-image", "url(" + jQuery(this).data("background") + ")");
        }
    });


    new Swiper(".slider_history", {
        loop: true,
        slidesPerView: 5,
        spaceBetween: 50,
        freeMode: false,
        watchSlidesProgress: true,
        centeredSlides: true,
        paginationClickable: true,
        slideToClickedSlide: true,
        speed: 1000,
        navigation: {
            nextEl: ".home_sec9 .next",
            prevEl: ".home_sec9 .prev",
        },

        autoplay: {
            delay: 4000,
            disableOnInteraction: false,
        },
        breakpoints: {
            // when window width is >= 320px
            767: {
                slidesPerView: 3,
            },
        }
    });




    new Swiper(".slider_post", {
        loop: false,
        slidesPerView: 4,
        speed: 1000,
        navigation: {
            nextEl: ".home_sec10 .next",
            prevEl: ".home_sec10 .prev",
        },
        autoplay: {
            delay: 4000,
            disableOnInteraction: false,
        },
        breakpoints: {
            // when window width is >= 320px
            1199: {
                slidesPerView: 3,
            },
            767: {
                slidesPerView: 1,
            },
        }
    });




    new Swiper(".slider_project", {
        loop: true,
        slidesPerView: 3,
        speed: 1000,
        spaceBetween: 50,
        autoplay: {
            delay: 4000,
            disableOnInteraction: false,
        },
        breakpoints: {
            // when window width is >= 320px
            767: {
                slidesPerView: 1,
            },
        }
    });
}
function add_fullpage() {
    if(jQuery('#add_fullpage').length) {

        let listTitle = [],
            listAnchor = []
        jQuery('#fullpage > section').each(function (index, item) {
            let title = jQuery(item).data('title'),
                anchor = jQuery(item).data('anchors'),
                _index = (index < 9) ? ('0' + (index + 1)) : (index + 1)
            listTitle.push(_index);
            listAnchor.push(anchor);
        });

        if (jQuery('#fullpage > footer').length) {
            let title = jQuery('#fullpage > footer').data('title'),
                anchor = jQuery('#fullpage > footer').data('anchors'),
                index = jQuery('#fullpage > footer').index(),
                _index = (index < 9) ? ('0' + (index + 1)) : (index + 1)
            listTitle.push(_index);
            listAnchor.push(anchor);
        }



        // Đặt thuộc tính autoScrolling của fullpage.js bằng biến fullpage_scroll


        jQuery('#fullpage').fullpage({
            //Navigation
            menu: '.landing-menu ul',
            lockAnchors: false,
            anchors: listAnchor,
            navigation: true,
            navigationPosition: 'left',
            navigationTooltips: listTitle,
            showActiveTooltip: true,
            slidesNavigation: true,
            slidesNavPosition: 'left',
            autoScrolling: true,
            //Scrolling
            css3: true,
            scrollingSpeed: 700,
            // autoScrolling: true,
            fitToSection: true,
            fitToSectionDelay: 1000,
            scrollBar: false,
            easing: 'easeInOutCubic',
            easingcss3: 'ease',
            loopBottom: false,
            loopTop: false,
            loopHorizontal: true,
            continuousVertical: false,
            continuousHorizontal: false,
            scrollHorizontally: false,
            interlockedSlides: false,
            dragAndMove: false,
            offsetSections: false,
            resetSliders: false,
            fadingEffect: false,
            normalScrollElements: '.about_sec_2 .content,.project_details_sec_7 .content_cs .content,ul.table_td,.home_sec3 .list_address ul',
            scrollOverflow: true,
            scrollOverflowReset: false,
            scrollOverflowOptions: null,
            touchSensitivity: 15,
            normalScrollElementTouchThreshold: 5,
            bigSectionsDestination: null,

            //Accessibility
            keyboardScrolling: true,
            animateAnchor: true,
            recordHistory: true,

            //Design
            controlArrows: true,
            verticalCentered: true,
            sectionsColor: ['#ccc', '#fff'],
            paddingTop: '0',
            paddingBottom: '0',
            fixedElements: '.main-navigation,.site-header,.wrap-menu,.nav-socials,#popup-form,.icon-popup,#popup-banner,#wpadminbar',
            responsiveWidth: 1199,
            responsiveHeight: 0,
            responsiveSlides: false,
            parallax: false,
            parallaxOptions: {
                type: 'reveal',
                percentage: 62,
                property: 'translate'
            },

            //Custom selectors
            sectionSelector: 'section, footer',
            // slideSelector: '.slide',

            lazyLoading: false,


            //events
            onLeave: function (index, nextIndex, direction) {
                if (direction == "down") {
                    jQuery('header').removeClass('headroom--pinned').addClass('headroom--not-bottom headroom--not-top headroom--unpinned');
                } else if (direction == "up") {
                    jQuery('header').removeClass('headroom--unpinned').addClass('headroom--pinned');
                }
                jQuery('.landing-menu li').removeClass('active');
                setTimeout(() => {
                    jQuery(jQuery('.landing-menu li a[href="' + window.location.hash + '"]')).addClass('active')
                    jQuery('html').removeClass('mobile-menu-open')
                    jQuery('.main-navigation').removeClass('toggled')
                }, 300);
                jQuery(jQuery(".section:nth-child(" + nextIndex + ")")).find(".is-animated").each(function (index) {
                    if (jQuery(window).width() > 992) {
                        animate(jQuery(this));
                    }
                });
                // countNum();
                //
                // DrawTextStop();

            },
            afterLoad: function (anchorLink, index) {
                if (jQuery('.fp-section').hasClass('active')) {
                    //DrawText();
                } else {
                    //DrawTextStop();
                }
                //console.log('Loaded ' + anchorLink + ' Index: ' + index);
                //jQuery('.fp-controlArrow').data('animation','bounce').data('duration','.6s').addClass('is-animated nav-arrow-bounce');
            },
            afterRender: function () {},
            afterResize: function () {},
            afterResponsive: function (isResponsive) {},
            afterSlideLoad: function (anchorLink, index, slideAnchor, slideIndex) {},
            onSlideLeave: function (anchorLink, index, slideIndex, direction, nextSlideIndex) {
                DrawTextStop();
            },
            onLeave: function(){
                jQuery('section [data-aos]').each(function(){
                    jQuery(this).removeClass("aos-animate")
                });
            },
            onSlideLeave: function(){
                jQuery('.slide [data-aos]').each(function(){
                    jQuery(this).removeClass("aos-animate")
                });
            },
            afterSlideLoad: function(){
                jQuery('.slide.active [data-aos]').each(function(){
                    jQuery(this).addClass("aos-animate")
                });
            },
            afterLoad: function(){
                jQuery('section.active [data-aos]').each(function(){
                    jQuery(this).addClass("aos-animate")
                });

                var title_sec = jQuery('.fp-section.active').attr('data-title');
                jQuery('.title_sec').text(title_sec)
                var num = jQuery('.fp-section.active').attr('data-num');
                jQuery('.nav_left .count .num').text(num)
            }
        });

        // jQuery(".about_sec_2 .content").on({
        //     mouseenter: function () {
        //         $.fn.fullpage.setAutoScrolling(false);
        //     },
        //     mouseleave: function () {
        //         $.fn.fullpage.setAutoScrolling(true);
        //     }
        // });

        // var i;
        // for (i = 1; i < 12; ++i) {
        //     var x = jQuery('#fp-nav ul li:nth-child('+i+') a').attr('href')
        //     var y = x.replace('#',"");
        //     var z = jQuery('section[data-anchors="'+y+'"]').attr('data-title')
        //     jQuery('a[href="#'+y+'"]+ .fp-tooltip').text(z)}

    }}


function hover_popup_image_map() {
    jQuery(document).ready(function(e) {
        jQuery('img[usemap]').rwdImageMaps();

        // jQuery('area').on('click', function() {
        //     alert($(this).attr('alt') + ' clicked');
        // });

        jQuery('area').hover(function() {
            var id = jQuery(this).attr('data-id');
            console.log(id);
            // jQuery('#axome-tooltip').html('<span>'+jQuery(this).attr('alt')+'</span>');

            jQuery('#axome-tooltip-'+id).show();

        }, function() {
            jQuery('.axome-tooltip').hide();
        });

        jQuery('area').mousemove(function(e) {
            var id = jQuery(this).attr('data-id');
            var offsetX = -100,
                offsetY = 0;
            jQuery('#axome-tooltip-'+id).offset({left: e.pageX + offsetX, top: e.pageY + offsetY});
        });
    });


}

function menu_header(){
    jQuery('.toggle_menu').click(function (){
        jQuery('.menu_header').addClass('active')
    })
    jQuery('.close_menu').click(function (){
        jQuery('.menu_header').removeClass('active')
    })
    jQuery('.main-nav ul li a').click(function (e){
        // e.preventDefault()
        jQuery('.menu_header').removeClass('active')
    })
}

function tien_ich(){
    jQuery("ul.list_hover li").on({
        mouseenter: function () {
            var id = jQuery(this).attr('data-id')
            jQuery('ul.list_dot li[data-id='+id+']').addClass('active')
            //stuff to do on mouse enter
        },
        mouseleave: function () {
            jQuery('ul.list_dot li').removeClass('active')

        }
    });

    jQuery("ul.list_dot li").on({
        mouseenter: function () {
            var id = jQuery(this).attr('data-id')
            jQuery('ul.list_hover li[data-id='+id+']').addClass('active')
            //stuff to do on mouse enter
        },
        mouseleave: function () {
            jQuery('ul.list_hover li').removeClass('active')

        }
    });
}

/** LOAD FIRST **/


function CRsite_loading(){
    if ( jQuery( ".CR-site-loading-default" ).length ) {
        jQuery('.CR-site-loading-circle:not(:hidden, :animated)').delay(600).fadeOut(400);
        jQuery('.CR-site-loading:not(:hidden, :animated)').delay(900).fadeOut(800);

        jQuery('body').removeClass('hide_scroll');

        setTimeout(function(){
            jQuery('.CR-site-loading-circle:not(:hidden, :animated)').delay(600).fadeOut(400);
            jQuery('.CR-site-loading:not(:hidden, :animated)').delay(900).fadeOut(800);
        }, 3000);
    }
}
function CRsite_loading_svg() {
    if(jQuery('.CR-site-loading-svg svg').length){
        var target = jQuery(".CR-site-loading-svg svg"),
            t = jQuery(target).find("path");

        jQuery(target).addClass("active");

        jQuery(t).css({
            "stroke-dasharray": "0 0"
        }), jQuery(t).each(function() {
            var i = this.getTotalLength();
            jQuery(this).css({
                "stroke-dasharray": i + " " + i
            }),
                jQuery(this).css({
                    "stroke-dashoffset": i,
                    "stroke-dasharray": i + " " + i
                })
        });

        jQuery(t).stop().animate({
            "stroke-dashoffset": 0
        }, 2000, "linear", function() {
            t.css({
                'stroke-dasharray': 4000,
                'stroke-dashoffset': 4000,
                'fill-opacity': 1,
                'stroke-opacity': 0,
            });

            jQuery(target).removeClass("active").addClass('hide');

        });

        setTimeout(() => {
            jQuery('.CR-site-loading-svg').addClass('hide');
        }, 600);
    }
}