const $ = jQuery.noConflict();
$(document).ready(function() {
    $('.js-example-basic-single').select2();
    $('.js-example-basic-single').on('change', function() {
        var value = $('.select2-selection__rendered').text();
        getDistrict(value);
    })
});
const url = 'http://dalatmilkweb.monamedia.net/template/data.json';
const elmCity = document.querySelector('.form-select .select-city');
const elmDistrict = document.querySelector('.form-select .select-district');
const elmListAddress = document.querySelector('.ul-list-address');
const btnCheckStore = document.getElementById('btn-check-store');

async function getAddress() {
    const data = await fetch(url).then(rs => rs.json());

    if (data) {
        data.map((item, i) => {
            const option = document.createElement('option')
            option.textContent = item.Tinh;
            option.setAttribute('value', item.Tinh);
            option.setAttribute('class', 'option');

            elmCity.appendChild(option);
        });
        var obj = {};
        $('.select-city .option').each(function() {
            var text = $(this).text();
            if (text == '') {
                $(this).remove();
            }
            if (obj[text]) {
                $(this).remove();
            } else {
                obj[text] = true;
            }
        });
    }
}

async function getDistrict(value) {
    if (value != 'default') {
        const data = await fetch(url).then(rs => rs.json());
        if (data) {
            data.map((item, i) => {
                if (item.Tinh == value) {
                    const option = document.createElement('option')
                    option.textContent = item.Quan;
                    option.setAttribute('value', item.Quan);
                    option.setAttribute('class', 'option');
                    option.setAttribute('data-city', item.Tinh);

                    elmDistrict.appendChild(option);
                }
            });
            var obj = {};
            $('.select-district .option').each(function() {
                var text = $(this).text();
                var dataCity = ($(this).attr('data-city'));
                if ($(this).text() != 'Quận/Huyện' && dataCity != value) {
                    $(this).remove();
                }
                if (text == '') {
                    $(this).remove();
                }
                if (obj[text]) {
                    $(this).remove();
                } else {
                    obj[text] = true;
                }
            });
        }
    } else {
        $('.select-district .option').each(function() {
            if ($(this).text() != 'Quận/Huyện') {
                $(this).remove();
            }
        });
    }
}

async function getListAddress(valueCity, valueDistrict) {
    const data = await fetch(url).then(rs => rs.json());
    if (data) {
        data.map((item, i) => {
            if (item.Tinh == valueCity && valueDistrict == 'default') {
                const li = document.createElement('li')
                li.textContent = item.DiaChi;
                elmListAddress.appendChild(li);
            } else if (item.Tinh == valueCity && item.Quan == valueDistrict) {
                const li = document.createElement('li')
                li.textContent = item.DiaChi;
                elmListAddress.appendChild(li);
            }
        });
    }
}

btnCheckStore.addEventListener('click', function() {
    const listStore = document.querySelector('.footer-list-address');
    const valueCity = document.getElementById('selectCity').value;
    const valueDistrict = document.getElementById('selectDistrict').value;

    if (valueCity == 'default') {
        alert('Bạn hãy chọn địa điểm phù hợp')
    } else {
        listStore.classList.remove('hidden');
        $('.ul-list-address li').each(function() {
            $(this).remove();
        })
        getListAddress(valueCity, valueDistrict);
    }
});

getAddress();