(function ($) {
	"use strict";

	$(document).ready(function () {
		initOwlCarousel();
		initMmenu();
		scrollTop();
		filterNganhNghe();
		responsiveQc();
	});

	function initOwlCarousel() {
		if ($(".owl-carousel").length) {
			$(".owl-carousel:not(.custom-owl)").each(function () {
				var owl = $(".owl-carousel");
				$(this).owlCarousel({
					margin: 0,
					autoplayTimeout: $(this).data("autotime"),
					smartSpeed: $(this).data("speed"),
					autoHeight: $(this).data("autoheight"),
					autoplay: $(this).data("autoplay"),
					items: $(this).data("carousel-items"),
					nav: $(this).data("nav"),
					dots: $(this).data("dots"),
					center: $(this).data("center"),
					loop: $(this).data("loop"),
					responsive: {
						0: {
							items: $(this).data("mobile"),
							margin: $(this).data("margintb"),
						},
						768: {
							items: $(this).data("tablet"),
							margin: $(this).data("margintb"),
						},
						992: {
							items: $(this).data("desktop-small"),
							margin: $(this).data("margintb"),
						},
						1680: {
							items: $(this).data("desktop"),
							margin: $(this).data("margintb"),
						},
					},
				});
			});
		}

		if ($(".custom-owl").length) {
			var sync1 = $("#sync1");
			var sync2 = $("#sync2");
			var slidesPerPage = 5;
			var syncedSecondary = true;

			sync1
				.owlCarousel({
					items: 1,
					slideSpeed: 2000,
					nav: true,
					autoplay: false,
					dots: false,
					loop: true,
					responsiveRefreshRate: 200,
				})
				.on("changed.owl.carousel", syncPosition);

			sync2
				.on("initialized.owl.carousel", function () {
					sync2.find(".owl-item").eq(0).addClass("current");
				})
				.owlCarousel({
					dots: false,
					nav: false,
					smartSpeed: 200,
					slideSpeed: 500,
					slideBy: slidesPerPage,
					responsiveRefreshRate: 100,
					responsive: {
						0: {
							items: 3,
						},
						768: {
							items: 3,
						},
						992: {
							items: 4,
						},
						1680: {
							items: slidesPerPage,
						},
					},
				})
				.on("changed.owl.carousel", syncPosition2);

			function syncPosition(el) {
				var count = el.item.count - 1;
				var current = Math.round(
					el.item.index - el.item.count / 2 - 0.5
				);

				if (current < 0) {
					current = count;
				}
				if (current > count) {
					current = 0;
				}

				sync2
					.find(".owl-item")
					.removeClass("current")
					.eq(current)
					.addClass("current");
				var onscreen = sync2.find(".owl-item.active").length - 1;
				var start = sync2.find(".owl-item.active").first().index();
				var end = sync2.find(".owl-item.active").last().index();

				if (current > end) {
					sync2.data("owl.carousel").to(current, 100, true);
				}
				if (current < start) {
					sync2
						.data("owl.carousel")
						.to(current - onscreen, 100, true);
				}
			}

			function syncPosition2(el) {
				if (syncedSecondary) {
					var number = el.item.index;
					sync1.data("owl.carousel").to(number, 100, true);
				}
			}

			sync2.on("click", ".owl-item", function (e) {
				e.preventDefault();
				var number = $(this).index();
				sync1.data("owl.carousel").to(number, 300, true);
			});
		}
	}
	function initMmenu() {
		$("#mobile_menu").mmenu({
			slidingSubmenus: true,
			extensions: ["border-full", "pagedim-black", "position-front"],
			wrappers: ["wordpress"],
			navbars: [
				{
					position: "top",
					content: ["close"],
				},
			],
		});
	}
	function scrollTop() {
		$(window).scroll(function () {
			// if ($(this).scrollTop() > 400) {
			// 	$(".daa-scroll-top").fadeIn();
			// } else {
			// 	$(".daa-scroll-top").fadeOut();
			// }
		});
		$(".daa-scroll-top").click(function () {
			$("html, body").animate({ scrollTop: 0 }, 800);
			return false;
		});
	}
	function filterNganhNghe() {
		$("#select_ngang_nghe").on("change", function () {
			let selected = $(this).val();
			let target;
			if (selected) {
				target = "/hoi-vien?kinh-doanh=" + selected;
			} else {
				target = "/hoi-vien";
			}
			window.location.href = target;
		});
	}
	function responsiveQc() {
		if ($(".qc-doc").length) {
			let qc_left = $(".qc-doc-1").clone();
			let qc_right = $(".qc-doc-2").clone();
			$(".qc_scroll_mb").append(qc_left);
			$(".qc_scroll_mb").append(qc_right);
		}
	}
})(jQuery);
